package net.bluemind.cql;

import java.util.List;

import net.bluemind.cql.persistence.CqlSchemaStore;
import net.bluemind.cql.schemas.CqlSchemaDescriptor;
import net.bluemind.cql.schemas.SchemaDescriptors;

public class CqlSchemaService {

	private final String keyspaceId;
	private final CqlSchemaStore store;

	public CqlSchemaService(String keyspaceId, CqlSchemaStore store) {
		this.keyspaceId = keyspaceId;
		this.store = store;
	}

	public void initialize() {
		List<CqlSchemaDescriptor> schemas = SchemaDescriptors.forKeyspace(keyspaceId);
		schemas.stream().parallel().forEach(store::create);
	}

}
