package net.bluemind.cql;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.cql.persistence.CqlKeyspaceStore;
import net.bluemind.cql.schemas.KeyspaceDescriptors;

public class CqlKeyspaceService {

	private final CqlKeyspaceStore ks;
	private static final Logger logger = LoggerFactory.getLogger(CqlKeyspaceService.class);

	public CqlKeyspaceService(CqlKeyspaceStore ks) {
		this.ks = ks;
	}

	public List<String> initialize() {
		List<String> created = new ArrayList<>();
		KeyspaceDescriptors.keyspaces().forEach(desc -> {
			long time = System.currentTimeMillis();
			ks.createKeyspace(desc);
			time = System.currentTimeMillis() - time;
			logger.info("Created keyspace {} in {}ms.", desc, time);
			created.add(desc.id());
		});
		return created;
	}

}
