/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.backup.continuous.model;

import java.util.Optional;

import net.bluemind.core.backup.continuous.model.impl.CHMInterner;

public interface TopicDescriptor {

	String installation();

	String domainUid();

	String owner();

	String type();

	String uid();

	Optional<String> suffix();

	static String trimInstallationId(String installationId) {
		return installationId;
	}

	default String physicalTopic() {
		StringBuilder b = new StringBuilder();
		b.append(installation().replace("bluemind-", "").replace("-", "")).append("-").append(domainUid());
		suffix().ifPresent(suffix -> b.append("__").append(suffix));
		return CHMInterner.get().intern(b.toString());
	}

	default String partitionKey(String uid) {
		return (!owner().equals("system")) ? owner() : uid;
	}
}