/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.lmtp.filter.imip;

import java.util.Optional;

import org.apache.james.mime4j.dom.Message;

import net.bluemind.common.telemetry.EmailTracer;
import net.bluemind.delivery.lmtp.common.LmtpEnvelope;
import net.bluemind.delivery.lmtp.filters.FilterException;
import net.bluemind.delivery.lmtp.filters.ILmtpFilterFactory;
import net.bluemind.delivery.lmtp.filters.IMessageFilter;

public class TracingFilter implements IMessageFilter {
	public static class Factory implements ILmtpFilterFactory {
		@Override
		public int getPriority() {
			return 1;
		}

		public Factory() {
			// ok
		}

		@Override
		public IMessageFilter getEngine() {
			return new TracingFilter();
		}

	}

	public TracingFilter() {
		// ok
	}

	@Override
	public Message filter(LmtpEnvelope env, Message message) throws FilterException {
		Optional.ofNullable(message.getHeader().getField(EmailTracer.TRACE_HEADER_NAME)).ifPresent(field -> {
			EmailTracer.trace("lmtp", field.getBody(), message.getMessageId(), message.getSubject());
		});
		return null; // Leave the message untouched
	}

}
