/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.exchange.mapi.notifications;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import net.bluemind.system.api.SystemState;
import net.bluemind.system.state.StateContext;

public class AbstractNotificationVerticle extends AbstractVerticle {

	public interface InterruptibleHandler {
		void consume(JsonObject js) throws InterruptedException;
	}

	protected void whenRunning(EventBus eb, String busAddress, InterruptibleHandler bodyHandler) {
		eb.consumer(busAddress, (Message<JsonObject> msg) -> {
			if (StateContext.getState() == SystemState.CORE_STATE_RUNNING) {
				try {
					bodyHandler.consume(msg.body());
				} catch (InterruptedException e) {
					Thread.currentThread().interrupt();
				}
			}
		});
	}

	protected void whenRunningBlocking(EventBus eb, String busAddress, InterruptibleHandler bodyHandler) {
		whenRunning(eb, busAddress, body -> vertx.executeBlocking(() -> {
			bodyHandler.consume(body);
			return null;
		}, false));
	}

}
