package net.bluemind.webmodule.server.handlers.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import net.bluemind.webmodule.server.WebModule;

public class AssetUtils {
	public static List<String> getAssetsList(WebModule module) {
		List<String> files = new ArrayList<>();
		files.addAll(module.resources.stream().flatMap(resource -> resource.getResources().stream())
				.filter(AssetUtils::assetsFilter).collect(Collectors.toSet()));
		return files;
	}

	private static Boolean assetsFilter(String path) {

		return !(path.startsWith(".") || path.endsWith(".devmode.js") || path.endsWith(".nocache.js")
				|| path.startsWith("WEB-INF"));
	}
}
