/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.exchange.mapi.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import net.bluemind.core.jdbc.Columns;
import net.bluemind.core.jdbc.JdbcAbstractStore.EntityPopulator;
import net.bluemind.core.jdbc.JdbcAbstractStore.StatementValues;
import net.bluemind.exchange.mapi.api.MapiPidMapping;

public class MapiPidMappingColumns {

	public static final Columns cols = Columns.create()//
			.col("pid_id")//
			.col("pid_name");

	public static StatementValues<MapiPidMapping> values() {
		return new StatementValues<MapiPidMapping>() {

			@Override
			public int setValues(Connection con, PreparedStatement statement, int index, int currentRow,
					MapiPidMapping value) throws SQLException {
				statement.setInt(index++, value.getId());
				statement.setString(index++, value.getName());
				return index;
			}
		};
	}

	public static EntityPopulator<MapiPidMapping> populator() {
		return (ResultSet rs, int index, MapiPidMapping f) -> {
			f.setId(rs.getInt(index++));
			f.setName(rs.getString(index++));
			return index;
		};
	}

	public static StatementValues<String> nameValue() {
		return new StatementValues<String>() {
			@Override
			public int setValues(Connection con, PreparedStatement statement, int index, int currentRow, String name)
					throws SQLException {
				statement.setString(index++, name);
				return index;
			}
		};
	}

}
