/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.common.restore;

import java.util.List;

import net.bluemind.core.task.service.IServerTaskMonitor;
import net.bluemind.dataprotect.api.DPError;
import net.bluemind.dataprotect.api.Restorable;

public interface IMonitoredRestoreRestorableItem {

	public Restorable item();

	public List<DPError> errors();

	public String domain();

	public String entryUid();

	public String displayName();

	public String liveEntryUid();

	public void setLiveEntryUid(String uid);

	public default void endTask() {

	}

	public default void monitorBegin(double total, String log) {

	}

	public default void monitorEnd(boolean success, String log, String result) {

	}

	public default void monitorLog(String format, Object... params) {

	}

	public default IServerTaskMonitor monitorSubWork(double i) {
		throw new UnsupportedOperationException("Method can only be called on an instance capable of monitoring");
	}

	public default IServerTaskMonitor getMonitor() {
		throw new UnsupportedOperationException("Method can only be called on an instance capable of monitoring");
	}

	public String startRestoreMsg(String type);

	public String startExportMsg(String type);

}
