/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.common.backup;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;

public class RestorableContainerItemBackupItem<T> implements AutoCloseable {

	public BackupContainerItemDescriptor<T> backupDescriptor;
	private InputStream dataStream;

	public RestorableContainerItemBackupItem() {
		super();
	}

	public RestorableContainerItemBackupItem(BackupContainerItemDescriptor<T> backupDescriptor) {
		this.backupDescriptor = backupDescriptor;
	}

	public RestorableContainerItemBackupItem(BackupContainerItemDescriptor<T> backupDescriptor, Path filePath)
			throws IOException {
		this.backupDescriptor = backupDescriptor;
		this.dataStream = Files.newInputStream(filePath, StandardOpenOption.READ);
	}

	@Override
	public void close() throws Exception {
		dataStream.close();
	}

	public InputStream dataStream() {
		return dataStream;
	}

	public void readDataStreamContent(ByteBuf icsData) {
		this.dataStream = new ByteBufInputStream(icsData);
	}

}
