<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * IdQuery.
 */
class IdQuery  {

  /*
   * @type ItemFlagFilter
   */
  public $filter;

  /*
   * @type int
   */
  public $limit;

  /*
   * @type int
   */
  public $offset;

  /*
   * @type long
   */
  public $knownContainerVersion;

  /*
   * Constructor
   */
  public function __construct() {
    $this->filter =   new ItemFlagFilter();
    $this->limit = 0;
    $this->offset = 0;
    $this->knownContainerVersion = 0;
  }

  public function toMap() {
    $data = array(    
        "filter" => empty($this->filter) ? null : $this->filter,    
        "limit" => empty($this->limit) ? null : $this->limit,    
        "offset" => empty($this->offset) ? null : $this->offset,    
        "knownContainerVersion" => empty($this->knownContainerVersion) ? null : $this->knownContainerVersion);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
