/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.node.server.handlers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;

public class PollFiles extends AbstractListFiles {

	private static final Logger logger = LoggerFactory.getLogger(PollFiles.class);

	public PollFiles() {
		super(String::matches);
	}

	@Override
	public void handle(final HttpServerRequest req) {
		String path = req.params().get("param0");
		req.body().andThen(body -> {
			JsonObject json = new JsonObject(body.result());
			String filenamePattern = json.getString("filenamePattern");
			int size = json.getInteger("size");
			logger.info("MATCH filenamePattern {} in {}", filenamePattern, path);
			super.handle(path, filenamePattern, size, req);
		});
	}

}
