/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.indexing.incremental;

import java.util.concurrent.TimeUnit;

import io.vertx.core.eventbus.DeliveryOptions;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.ContainerUid;
import net.bluemind.lib.vertx.VertxPlatform;

public class TriggerIndexing {
	private static final DeliveryOptions eventbusDeliveryOptions = new DeliveryOptions()
			.setSendTimeout(TimeUnit.MINUTES.toMillis(2));

	private TriggerIndexing() {
	}

	public static void forContainer(ContainerUid cuid) {
		forContainer(cuid.value());
	}

	private static void forContainer(String containerUid) {
		VertxPlatform.eventBus().send("index.dirty", containerUid, eventbusDeliveryOptions);
	}

	public static void forContainer(Container c) {
		forContainer(c.uid);
	}

	public static long indexingGeneration() {
		return IncrementalIndexer.GEN.get();
	}

	public static int queued() {
		return IncrementalIndexer.queuedIndexing();
	}
}
