package net.bluemind.directory.hollow.datamodel.consumer.multicore.index.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;

import net.bluemind.directory.hollow.datamodel.AddressBookRecordIndexOnly;
import net.bluemind.directory.hollow.datamodel.AnrToken;
import net.bluemind.directory.hollow.datamodel.consumer.multicore.index.IDeserializerIndexMulti;
import net.bluemind.directory.hollow.datamodel.consumer.multicore.index.trie.Trie;

public class ByNameOrEmailPrefix implements IDeserializerIndexMulti {

	private static final int ANR_MAXSIZE = 4;
	private static final Splitter CHUNKS = Splitter.on(CharMatcher.whitespace().or(CharMatcher.anyOf(".-@")))
			.omitEmptyStrings();

	Trie index = new Trie();

	@Override
	public Optional<String> simpleQueryFieldName() {
		return Optional.of("anr");
	}

	@Override
	public void add(AddressBookRecordIndexOnly addressBook, String uid) {
		addressBook.getAnr().stream().map(AnrToken::getToken).forEach(anr -> index.put(anr, uid));
	}

	@Override
	public Collection<String> getUids(String anr) {
		if (anr == null) {
			return Collections.emptySet();
		}

		Set<String> fullAnrUids = index.get(anr);
		if (!fullAnrUids.isEmpty()) {
			return fullAnrUids;
		}

		String domainRegex = "\\.[a-z]{2,}$";
		String noDomainAnr = anr.replaceAll(domainRegex, "");

		List<String> chunks = StreamSupport.stream(CHUNKS.split(noDomainAnr).spliterator(), false) //
				.map(chunk -> chunk.toLowerCase().substring(0, Math.min(ANR_MAXSIZE, chunk.length()))).toList();

		Stream<String> chunkUids = chunks.stream().flatMap(chunk -> index.get(chunk).stream());
		return Stream.concat(fullAnrUids.stream(), chunkUids).distinct().toList();
	}

}
