package net.bluemind.directory.hollow.datamodel.consumer.multicore.index;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import net.bluemind.directory.hollow.datamodel.AddressBookRecordIndexOnly;

public abstract class DeserializerIndexMonoMap implements IDeserializerIndexMono {

	protected Map<String, String> index = new HashMap<>();

	@Override
	public void add(AddressBookRecordIndexOnly addressBook, String uid) {
		index.put(getIndexKey(addressBook), uid);
	}

	@Override
	public Optional<String> getUid(String key) {
		return Optional.ofNullable(index.get(key));
	}

	public abstract String getIndexKey(AddressBookRecordIndexOnly addressBookRecord);
}
