/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.repository;

import java.sql.SQLException;
import java.time.Instant;
import java.util.List;

import net.bluemind.backend.mail.replica.api.Tier;
import net.bluemind.backend.mail.replica.api.TierMove;
import net.bluemind.backend.mail.replica.api.TierMove.TierAddResult;

public interface IBodyTierChangeStore {
	void insert(String messageBodyGuid, Instant changeAfter, Tier tier) throws SQLException;

	List<TierMove> getMoves(int limit) throws SQLException;

	void deleteMoves(List<String> guids) throws SQLException;

	void retryDelayedMoves(List<String> guids) throws SQLException;

	void truncate() throws SQLException;

	TierAddResult rebuildTierMoves(int limit, int archiveDays, byte[] minGuid) throws SQLException;
}
