/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailflow.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailflowRuleGwtSerDer implements GwtSerDer<net.bluemind.mailflow.api.MailflowRule> {

	public MailflowRuleGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailflow.api.MailflowRule deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailflow.api.MailflowRule ret = new net.bluemind.mailflow.api.MailflowRule();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailflow.api.MailflowRule ret, JSONObject json) {
		JSONValue ruleIdentifierJSON = json.get("ruleIdentifier");
		ret.ruleIdentifier =  GwtSerDerUtils.STRING.deserialize(ruleIdentifierJSON);
		JSONValue configurationJSON = json.get("configuration");
		ret.configuration =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(configurationJSON);
		JSONValue childrenJSON = json.get("children");
		ret.children =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailflow.api.gwt.serder.MailflowRuleGwtSerDer()).deserialize(childrenJSON);
	}

	public void deserializeTo(net.bluemind.mailflow.api.MailflowRule ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("ruleIdentifier")) {
			JSONValue ruleIdentifierJSON = json.get("ruleIdentifier");
			ret.ruleIdentifier =  GwtSerDerUtils.STRING.deserialize(ruleIdentifierJSON);
		}
		if (!childPropertiesToIgnore.contains("configuration")) {
			JSONValue configurationJSON = json.get("configuration");
			ret.configuration =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(configurationJSON);
		}
		if (!childPropertiesToIgnore.contains("children")) {
			JSONValue childrenJSON = json.get("children");
			ret.children =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailflow.api.gwt.serder.MailflowRuleGwtSerDer()).deserialize(childrenJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailflow.api.MailflowRule o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailflow.api.MailflowRule o, JSONObject ret) {

		ret.put("ruleIdentifier",  GwtSerDerUtils.STRING.serialize( o.ruleIdentifier ));
		ret.put("configuration",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.configuration ));
		ret.put("children",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailflow.api.gwt.serder.MailflowRuleGwtSerDer()).serialize( o.children ));
	}

	public void serializeTo(net.bluemind.mailflow.api.MailflowRule o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("ruleIdentifier")) {
			ret.put("ruleIdentifier",  GwtSerDerUtils.STRING.serialize( o.ruleIdentifier ));
		}
		if (!childPropertiesToIgnore.contains("configuration")) {
			ret.put("configuration",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.configuration ));
		}
		if (!childPropertiesToIgnore.contains("children")) {
			ret.put("children",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailflow.api.gwt.serder.MailflowRuleGwtSerDer()).serialize( o.children ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}