<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * UserAccount.
 */
class UserAccount  {

  /*
   * @type String
   */
  public $login;

  /*
   * @type String
   */
  public $credentials;

  /*
   * @type Map
   */
  public $additionalSettings;

  /*
   * Constructor
   */
  public function __construct() {
    $this->login = "";
    $this->credentials = "";
    $this->additionalSettings = array();
  }

  public function toMap() {
    $data = array(    
        "login" => empty($this->login) ? null : $this->login,    
        "credentials" => empty($this->credentials) ? null : $this->credentials,    
        "additionalSettings" => empty($this->additionalSettings) ? null : $this->additionalSettings);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
