/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.service;

import java.sql.SQLException;

import net.bluemind.core.api.fault.ErrorCode;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.container.repository.IContainerStore;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.repository.provider.RepositoryProvider;
import net.bluemind.system.api.IInternalCredentials;
import net.bluemind.system.service.internal.CredentialsService;

public class InternalCredentialsServiceFactory implements ServerSideServiceProvider.IServerSideServiceFactory<IInternalCredentials> {

	@Override
	public Class<IInternalCredentials> factoryClass() {
		return IInternalCredentials.class;
	}

	@Override
	public IInternalCredentials instance(BmContext context, String... params) throws ServerFault {
		if (params == null || params.length < 1 || params[0] == null || params[0].isBlank()) {
			throw new ServerFault("Wrong number of instance parameters: domainUID parameter is mandatory",
					ErrorCode.INVALID_PARAMETER);
		}
		String domainUid = params[0];

		IContainerStore containerStore = RepositoryProvider.instance(IContainerStore.class, context,
				DataLocation.directory());
		Container container = null;

		try {
			container = containerStore.get(domainUid);
		} catch (SQLException e) {
			throw ServerFault.sqlFault(e);
		}

		if (container == null) {
			throw new ServerFault("container " + domainUid + " not found");
		}

		return new CredentialsService(context, domainUid, container);
	}

}
