/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.mailbox.repository;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

import net.bluemind.core.api.Email;
import net.bluemind.core.container.repository.IItemValueStore;
import net.bluemind.mailbox.api.IMailboxes.MailboxLocation;
import net.bluemind.mailbox.api.Mailbox;

public interface IMailboxStore extends IItemValueStore<Mailbox> {

	boolean nameAlreadyUsed(Long itemId, Mailbox mbox) throws SQLException;

	boolean emailAlreadyUsed(Long itemId, Collection<Email> emails) throws SQLException;

	String emailSearch(String email) throws SQLException;

	String nameSearch(String email) throws SQLException;

	List<String> routingSearch(Mailbox.Routing routing) throws SQLException;

	List<String> allUids() throws SQLException;

	public Optional<MailboxLocation> getLocation(String ownerUid) throws SQLException;

}
