/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.rules.conditions.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterRuleFilterGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter> {

	public MailFilterRuleFilterGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		return delegateDeserialization(json);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter ret, JSONObject json) {
		JSONValue fieldsJSON = json.get("fields");
		ret.fields =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(fieldsJSON);
		JSONValue operatorJSON = json.get("operator");
		ret.operator =  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleOperatorNameGwtSerDer().deserialize(operatorJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("fields")) {
			JSONValue fieldsJSON = json.get("fields");
			ret.fields =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(fieldsJSON);
		}
		if (!childPropertiesToIgnore.contains("operator")) {
			JSONValue operatorJSON = json.get("operator");
			ret.operator =  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleOperatorNameGwtSerDer().deserialize(operatorJSON);
		}
	}

	public net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter delegateDeserialization(JSONObject json) {
		JSONValue discriminatorValue = json.get("operator");
		String discriminator = GwtSerDerUtils.STRING.deserialize(discriminatorValue);
		switch (discriminator) {
		case "EXISTS":
			return new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterExistsGwtSerDer().deserialize(json);
		case "EQUALS":
			return new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterEqualsGwtSerDer().deserialize(json);
		case "MATCHES":
			return new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterMatchesGwtSerDer().deserialize(json);
		case "CONTAINS":
			return new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterContainsGwtSerDer().deserialize(json);
		case "RANGE":
			return new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterRangeGwtSerDer().deserialize(json);
		}
		return null;
	}

	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter o) {
		if (o == null) {
			return null;
		}

		return delegateSerialization(o);
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter o, JSONObject ret) {

		ret.put("fields",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.fields ));
		ret.put("operator",  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleOperatorNameGwtSerDer().serialize( o.operator ));
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("fields")) {
			ret.put("fields",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.fields ));
		}
		if (!childPropertiesToIgnore.contains("operator")) {
			ret.put("operator",  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleOperatorNameGwtSerDer().serialize( o.operator ));
		}
	}

	public JSONValue delegateSerialization(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter o) {
		String discriminator = o.operator.toString();
		switch (discriminator) {
		case "EXISTS":
			return new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterExistsGwtSerDer().serialize((net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterExists)o);
		case "EQUALS":
			return new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterEqualsGwtSerDer().serialize((net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterEquals)o);
		case "MATCHES":
			return new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterMatchesGwtSerDer().serialize((net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterMatches)o);
		case "CONTAINS":
			return new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterContainsGwtSerDer().serialize((net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterContains)o);
		case "RANGE":
			return new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterRangeGwtSerDer().serialize((net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterRange)o);
		}
		return null;
	}

	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}