/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.tx.outbox.repository;

import java.sql.SQLException;
import java.util.List;

public interface ITxOutboxRepository {

	public FlushSeqHolder seqHolder();

	public record KafkaPayload(long outboxId, String domainUid, String partKey, byte[] key, byte[] value) {

	}

	long forKafka(String tgtTopic, String partKey, byte[] key, byte[] value) throws SQLException;

	List<Long> kafkaPending(int limit) throws SQLException;

	default List<Long> kafkaPending(int limit, List<Long> inFlight) throws SQLException {
		return kafkaPending(limit);
	}

	KafkaPayload get(long id) throws SQLException;

	default List<KafkaPayload> mget(List<Long> ids) throws SQLException {
		return ids.stream().map(id -> {
			try {
				return get(id);
			} catch (SQLException e) {
				throw new RuntimeException(e); // NOSONAR
			}
		}).toList();
	}

	/**
	 * delete outbox items <= id
	 * 
	 * @param id deletes everything up to (and including) id
	 * @throws SQLException
	 */
	void deleteOffsets(List<Long> offsets) throws SQLException;

}
