/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.metrics;

import io.github.resilience4j.core.Clock;
import io.github.resilience4j.core.metrics.Metrics;
import io.github.resilience4j.core.metrics.PackedAggregation;
import io.github.resilience4j.core.metrics.Snapshot;
import io.github.resilience4j.core.metrics.SnapshotImpl;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;

public class LockFreeSlidingTimeWindowMetrics
implements Metrics {
    private static final long TIME_SLICE_DURATION_IN_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private static final VarHandle HEAD;
    private static final VarHandle TAIL;
    private static final VarHandle TIME_SLICE;
    private static final VarHandle NEXT;
    private final Clock clock;
    private final int windowSize;
    private volatile Node headRef;
    private volatile Node tailRef;

    public LockFreeSlidingTimeWindowMetrics(int windowSize, Clock clock) {
        long time = clock.monotonicTime();
        this.clock = clock;
        this.windowSize = windowSize;
        this.tailRef = this.headRef = new Node(new TimeSlice(0, time, new PackedAggregation(), false), null);
        for (int i = 1; i < this.windowSize; ++i) {
            Node newNode;
            this.tailRef.next = newNode = new Node(new TimeSlice(i, time, new PackedAggregation(), false), null);
            this.tailRef = newNode;
        }
    }

    public LockFreeSlidingTimeWindowMetrics(int windowSize) {
        this(windowSize, Clock.SYSTEM);
    }

    @Override
    public Snapshot record(long duration, TimeUnit durationUnit, Metrics.Outcome outcome) {
        TimeSlice next;
        while (true) {
            this.advanceTimeSlice();
            Node tail = this.tailRef;
            TimeSlice current = tail.timeSlice;
            if (current.processed) continue;
            next = current.copy();
            next.record(duration, durationUnit, outcome);
            if (TIME_SLICE.compareAndSet(tail, current, next)) break;
        }
        return new SnapshotImpl(next.stats);
    }

    @Override
    public Snapshot getSnapshot() {
        this.advanceTimeSlice();
        return new SnapshotImpl(this.tailRef.timeSlice.stats);
    }

    private void advanceTimeSlice() {
        while (true) {
            long elapsedSlices;
            long elapsedTimeInNextSlice;
            Node tail = this.tailRef;
            TimeSlice current = tail.timeSlice;
            long now = this.clock.monotonicTime();
            long elapsedTime = now - current.time;
            if (elapsedTime < TIME_SLICE_DURATION_IN_NANOS) {
                return;
            }
            if (!current.processed) {
                TimeSlice processed = new TimeSlice(current.second, current.time, current.stats, true);
                if (!TIME_SLICE.compareAndSet(tail, current, processed)) continue;
                current = processed;
            }
            if ((elapsedTimeInNextSlice = elapsedTime - (elapsedSlices = Math.min(elapsedTime / TIME_SLICE_DURATION_IN_NANOS, (long)this.windowSize)) * TIME_SLICE_DURATION_IN_NANOS) >= TIME_SLICE_DURATION_IN_NANOS) {
                elapsedTimeInNextSlice = 0L;
            }
            int nextSecond = (current.second + 1) % this.windowSize;
            long nextTime = now - (elapsedSlices - 1L) * TIME_SLICE_DURATION_IN_NANOS - elapsedTimeInNextSlice;
            this.updateWindow(nextSecond, nextTime);
        }
    }

    private void updateWindow(int second, long time) {
        while (true) {
            Node head = this.headRef;
            Node headNext = head.next;
            Node tail = this.tailRef;
            Node tailNext = tail.next;
            if (head != this.headRef || tail != this.tailRef) continue;
            TimeSlice headTimeSlice = head.timeSlice;
            TimeSlice tailTimeSlice = tail.timeSlice;
            int nextSecond = (tailTimeSlice.second + 1) % this.windowSize;
            if (second != nextSecond || time < tailTimeSlice.time) {
                return;
            }
            if (tailNext == null) {
                PackedAggregation nextStats = tailTimeSlice.stats.copy();
                nextStats.discard(headTimeSlice.stats);
                TimeSlice nextTimeSlice = new TimeSlice(nextSecond, time, nextStats, false);
                Node nextNode = new Node(nextTimeSlice, null);
                if (!NEXT.compareAndSet(tail, null, nextNode) || !HEAD.compareAndSet(this, head, headNext)) continue;
                TAIL.compareAndSet(this, tail, nextNode);
                return;
            }
            if (tailNext.timeSlice.second == headTimeSlice.second) {
                if (!HEAD.compareAndSet(this, head, headNext)) continue;
                TAIL.compareAndSet(this, tail, tailNext);
                continue;
            }
            TAIL.compareAndSet(this, tail, tailNext);
        }
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            HEAD = l.findVarHandle(LockFreeSlidingTimeWindowMetrics.class, "headRef", Node.class);
            TAIL = l.findVarHandle(LockFreeSlidingTimeWindowMetrics.class, "tailRef", Node.class);
            TIME_SLICE = l.findVarHandle(Node.class, "timeSlice", TimeSlice.class);
            NEXT = l.findVarHandle(Node.class, "next", Node.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class Node {
        volatile TimeSlice timeSlice;
        volatile Node next;

        Node(TimeSlice timeSlice, Node next) {
            TIME_SLICE.set(this, timeSlice);
            NEXT.set(this, next);
        }
    }

    public static class TimeSlice {
        final int second;
        final long time;
        final PackedAggregation stats;
        final boolean processed;

        public TimeSlice(int second, long time, PackedAggregation stats, boolean processed) {
            this.second = second;
            this.time = time;
            this.stats = stats;
            this.processed = processed;
        }

        public TimeSlice copy() {
            return new TimeSlice(this.second, this.time, this.stats.copy(), this.processed);
        }

        public void record(Long duration, TimeUnit durationUnit, Metrics.Outcome outcome) {
            this.stats.record(duration, durationUnit, outcome);
        }
    }
}

