/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.transformations.sql;

import java.util.function.Function;
import java.util.function.Supplier;
import net.datafaker.transformations.Transformer;
import net.datafaker.transformations.sql.Casing;
import net.datafaker.transformations.sql.SqlTransformer;
import net.datafaker.transformations.sql.TriFunction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SqlDialect {
    ANSI("`"),
    BIGQUERY("`", Casing.UNCHANGED),
    CALCITE("\""),
    CLICKHOUSE("`"),
    EXASOL("\""),
    FIREBOLT("\""),
    H2("\""),
    INFOBRIGHT("`"),
    LUCIDDB("\""),
    MARIADB("`", Casing.TO_LOWER),
    MSSQL("[]"),
    MYSQL("`", Casing.UNCHANGED),
    NETEZZA("\""),
    ORACLE("\"", Casing.TO_UPPER, (columns, values, caze) -> {
        String insertAll = SqlTransformer.SQLKeyWords.INSERT_ALL.getValue((SqlTransformer.Case)((Object)caze)) + System.lineSeparator() + "    " + SqlTransformer.SQLKeyWords.INTO.getValue((SqlTransformer.Case)((Object)caze)) + " ";
        String valuesKeyWord = " " + SqlTransformer.SQLKeyWords.VALUES.getValue((SqlTransformer.Case)((Object)caze)) + " ";
        return insertAll + (String)columns.get() + valuesKeyWord + (String)values.get();
    }, (columns, values, caze) -> {
        String into = "    " + SqlTransformer.SQLKeyWords.INTO.getValue((SqlTransformer.Case)((Object)caze)) + " ";
        String valuesKeyWord = " " + SqlTransformer.SQLKeyWords.VALUES.getValue((SqlTransformer.Case)((Object)caze)) + " ";
        return into + (String)columns.get() + valuesKeyWord + (String)values.get();
    }, caze -> Transformer.LINE_SEPARATOR + SqlTransformer.SQLKeyWords.SELECT_1_FROM_DUAL.getValue((SqlTransformer.Case)((Object)caze))),
    PARACCEL("\""),
    PHOENIX("\""),
    POSTGRES("\""),
    PRESTO("\"", Casing.UNCHANGED),
    REDSHIFT("\"", Casing.TO_LOWER),
    SNOWFLAKE("\""),
    SPARKSQL("`"){

        @Override
        public String getCompositePrefix(SqlTransformer.Case caze) {
            return SqlTransformer.SQLKeyWords.NAMED_STRUCT.getValue(caze);
        }

        @Override
        public String getArrayStart() {
            return "(";
        }

        @Override
        public String getArrayEnd() {
            return ")";
        }

        @Override
        public String getFieldPrefix(String fieldName) {
            return fieldName;
        }
    }
    ,
    TERADATA("\""),
    VERTICA("\"", Casing.UNCHANGED);

    private final String sqlQuoteIdentifier;
    private final Casing unquotedCasing;
    private final TriFunction<Supplier<String>, Supplier<String>, SqlTransformer.Case, String> batchFirstRow;
    private final TriFunction<Supplier<String>, Supplier<String>, SqlTransformer.Case, String> batchOtherRows;
    private final Function<SqlTransformer.Case, String> lastBatchRow;
    private static final String DEFAULT_BEFORE_EACH_BATCH_PREFIX = "       ";

    private SqlDialect(String sqlQuoteIdentifier, Casing casing, TriFunction<Supplier<String>, Supplier<String>, SqlTransformer.Case, String> batchFirstRow, TriFunction<Supplier<String>, Supplier<String>, SqlTransformer.Case, String> batchOtherRows, Function<SqlTransformer.Case, String> lastBatchRow) {
        this.sqlQuoteIdentifier = sqlQuoteIdentifier;
        this.unquotedCasing = casing;
        this.batchFirstRow = batchFirstRow;
        this.batchOtherRows = batchOtherRows;
        this.lastBatchRow = lastBatchRow;
    }

    private SqlDialect(String sqlQuoteIdentifier, TriFunction<Supplier<String>, Supplier<String>, SqlTransformer.Case, String> batchFirstRow, TriFunction<Supplier<String>, Supplier<String>, SqlTransformer.Case, String> batchOtherRows, Function<SqlTransformer.Case, String> lastBatchRow) {
        this(sqlQuoteIdentifier, Casing.DEFAULT_CASING, batchFirstRow, batchOtherRows, lastBatchRow);
    }

    private SqlDialect(String sqlQuoteIdentifier, Casing casing) {
        this(sqlQuoteIdentifier, casing, AuxiliaryConstants.DEFAULT_FIRST_ROW, AuxiliaryConstants.DEFAULT_OTHER_ROWS, s -> "");
    }

    private SqlDialect(String sqlQuoteIdentifier) {
        this(sqlQuoteIdentifier, Casing.DEFAULT_CASING);
    }

    public String getSqlQuoteIdentifier() {
        return this.sqlQuoteIdentifier;
    }

    public Casing getUnquotedCasing() {
        return this.unquotedCasing;
    }

    public static String getFirstRow(SqlDialect dialect, Supplier<String> input, Supplier<String> input2, SqlTransformer.Case keywordCase) {
        return dialect == null ? AuxiliaryConstants.DEFAULT_FIRST_ROW.apply(input, input2, keywordCase) : dialect.batchFirstRow.apply(input, input2, keywordCase);
    }

    public static String getOtherRow(SqlDialect dialect, Supplier<String> input, Supplier<String> input2, SqlTransformer.Case keywordCase) {
        return dialect == null ? AuxiliaryConstants.DEFAULT_OTHER_ROWS.apply(input, input2, keywordCase) : dialect.batchOtherRows.apply(input, input2, keywordCase);
    }

    public static String getLastRowSuffix(SqlDialect dialect, SqlTransformer.Case caze) {
        return dialect == null ? "" : dialect.lastBatchRow.apply(caze);
    }

    public String getCompositePrefix(SqlTransformer.Case caze) {
        return SqlTransformer.SQLKeyWords.ROW.getValue(caze);
    }

    public String getFieldPrefix(String fieldName) {
        return "";
    }

    public String getArrayStart() {
        return "[";
    }

    public String getArrayEnd() {
        return "]";
    }

    static class AuxiliaryConstants {
        static final TriFunction<Supplier<String>, Supplier<String>, SqlTransformer.Case, String> DEFAULT_FIRST_ROW = (supplier, supplier2, caze) -> {
            String insertAll = SqlTransformer.SQLKeyWords.INSERT_INTO.getValue((SqlTransformer.Case)((Object)caze)) + " ";
            String values = Transformer.LINE_SEPARATOR + SqlTransformer.SQLKeyWords.VALUES.getValue((SqlTransformer.Case)((Object)caze)) + " ";
            return insertAll + (String)supplier.get() + values + (String)supplier2.get();
        };
        static final TriFunction<Supplier<String>, Supplier<String>, SqlTransformer.Case, String> DEFAULT_OTHER_ROWS = (supplier, supplier2, caze) -> SqlDialect.DEFAULT_BEFORE_EACH_BATCH_PREFIX + (String)supplier2.get();

        AuxiliaryConstants() {
        }
    }
}

