/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.shaded.curiousoddman.rgxgen.visitors;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.random.RandomGenerator;
import net.datafaker.shaded.curiousoddman.rgxgen.config.RgxGenOption;
import net.datafaker.shaded.curiousoddman.rgxgen.config.RgxGenProperties;
import net.datafaker.shaded.curiousoddman.rgxgen.visitors.GenerationVisitor;
import net.datafaker.shaded.curiousoddman.rgxgen.visitors.GenerationVisitorCaseInsensitive;
import net.datafaker.shaded.curiousoddman.rgxgen.visitors.NotMatchingCaseInsensitiveGenerationVisitor;
import net.datafaker.shaded.curiousoddman.rgxgen.visitors.NotMatchingGenerationVisitor;

public class GenerationVisitorBuilder {
    private final boolean aGenerateMatching;
    private RandomGenerator aRandom;
    private Map<Integer, String> aGroupsValues;
    private RgxGenProperties aProperties;

    public GenerationVisitorBuilder(boolean generateMatching) {
        this.aGenerateMatching = generateMatching;
    }

    public GenerationVisitorBuilder withRandom(RandomGenerator random) {
        this.aRandom = random;
        return this;
    }

    public GenerationVisitor get() {
        if (this.aRandom == null) {
            this.aRandom = new Random();
        }
        if (this.aGroupsValues == null) {
            this.aGroupsValues = new HashMap<Integer, String>();
        }
        if (this.aGenerateMatching) {
            if (RgxGenOption.CASE_INSENSITIVE.getFromProperties(this.aProperties).booleanValue()) {
                return new GenerationVisitorCaseInsensitive(this.aRandom, this.aGroupsValues, this.aProperties);
            }
            return new GenerationVisitor(this.aRandom, this.aGroupsValues, this.aProperties);
        }
        if (RgxGenOption.CASE_INSENSITIVE.getFromProperties(this.aProperties).booleanValue()) {
            return new NotMatchingCaseInsensitiveGenerationVisitor(this.aRandom, this.aGroupsValues, this.aProperties);
        }
        return new NotMatchingGenerationVisitor(this.aRandom, this.aGroupsValues, this.aProperties);
    }

    public GenerationVisitorBuilder withProperties(RgxGenProperties properties) {
        this.aProperties = properties;
        return this;
    }
}

