/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public record WeightedRandomSelector(Random random) {
    private static final String WEIGHT_KEY = "weight";
    private static final String VALUE_KEY = "value";

    public WeightedRandomSelector(Random random) {
        this.random = random != null ? random : new Random();
    }

    public <T> T select(List<Map<String, Object>> items) {
        WeightedRandomSelector.validateItemsList(items);
        Object[] values = new Object[items.size()];
        double[] cumulativeWeights = WeightedRandomSelector.preprocessItems(items, values);
        double randomValue = this.random.nextDouble() * cumulativeWeights[cumulativeWeights.length - 1];
        return WeightedRandomSelector.selectWeightedElement(randomValue, cumulativeWeights, values);
    }

    private static void validateItemsList(List<Map<String, Object>> items) {
        if (items == null) {
            throw new IllegalArgumentException("Input list cannot be null");
        }
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Input list cannot be empty");
        }
        HashSet<Object> uniqueValues = new HashSet<Object>();
        for (Map<String, Object> item : items) {
            WeightedRandomSelector.validateItem(item);
            WeightedRandomSelector.assertUniqueValues(item, uniqueValues);
        }
    }

    private static void assertUniqueValues(Map<String, Object> item, Set<Object> values) {
        Object value = item.get(VALUE_KEY);
        if (!values.add(value)) {
            throw new IllegalArgumentException("Duplicate value found: " + String.valueOf(value) + ". Values must be unique.");
        }
    }

    private static void validateItem(Map<String, Object> item) {
        if (item == null) {
            throw new IllegalArgumentException("Item cannot be null");
        }
        if (item.isEmpty()) {
            throw new IllegalArgumentException("Item cannot be empty");
        }
        if (!item.containsKey(WEIGHT_KEY) || !item.containsKey(VALUE_KEY)) {
            throw new IllegalArgumentException("Each item must contain 'weight' and 'value' keys");
        }
        WeightedRandomSelector.validateValue(item.get(VALUE_KEY));
        WeightedRandomSelector.validateWeight(item.get(WEIGHT_KEY));
    }

    private static void validateValue(Object valueObj) {
        if (valueObj == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
    }

    private static void validateWeight(Object weightObj) {
        if (!(weightObj instanceof Double)) {
            throw new IllegalArgumentException("Weight must be a non-null Double");
        }
        Double weight = (Double)weightObj;
        if (weight < 0.0 || Double.isNaN(weight) || Double.isInfinite(weight)) {
            throw new IllegalArgumentException("Weight must be a non-negative number and cannot be NaN or infinite");
        }
    }

    private static void validateTotalWeight(double totalWeight) {
        if (totalWeight <= 0.0) {
            throw new IllegalArgumentException("The total weight must be greater than 0. At least one item must have a positive weight");
        }
    }

    static double[] preprocessItems(List<Map<String, Object>> items, Object[] values) {
        double[] cumulativeWeights = new double[items.size()];
        double totalWeight = 0.0;
        for (int i = 0; i < items.size(); ++i) {
            double weight = (Double)items.get(i).get(WEIGHT_KEY);
            if (Double.MAX_VALUE - totalWeight < weight) {
                throw new IllegalArgumentException("Sum of the weights exceeds Double.MAX_VALUE");
            }
            cumulativeWeights[i] = totalWeight += weight;
            values[i] = items.get(i).get(VALUE_KEY);
        }
        WeightedRandomSelector.validateTotalWeight(totalWeight);
        return cumulativeWeights;
    }

    static <T> T selectWeightedElement(double randomValue, double[] cumulativeWeights, Object[] values) {
        int index = Arrays.binarySearch(cumulativeWeights, randomValue);
        int n = index = index < 0 ? -index - 1 : index;
        if (index >= cumulativeWeights.length) {
            index = cumulativeWeights.length - 1;
        }
        return (T)values[index];
    }
}

