/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import java.util.function.Function;

public record Range<T extends Comparable<T>>(Bound<T> from, Bound<T> to) {
    public static <T extends Comparable<T>> Range<T> inclusive(T from, T to) {
        if (from.compareTo(to) > 0) {
            throw new IllegalArgumentException("Lower bound (%s) > upper bound (%s)".formatted(from, to));
        }
        return new Range<T>(new Bound<T>(from, End.INCLUSIVE), new Bound<T>(to, End.INCLUSIVE));
    }

    public static <T extends Comparable<T>> Range<T> inclusiveExclusive(T from, T to) {
        if (from.compareTo(to) >= 0) {
            throw new IllegalArgumentException("Lower bound (%s) >= upper bound (%s)".formatted(from, to));
        }
        return new Range<T>(new Bound<T>(from, End.INCLUSIVE), new Bound<T>(to, End.EXCLUSIVE));
    }

    public static <T extends Number> Range<T> exclusive(T from, T to) {
        if (to.longValue() == Long.MIN_VALUE) {
            throw new IllegalArgumentException("Lower bound (%s) >= upper bound (%s)".formatted(from, to));
        }
        long upperLimit = to.longValue() - 1L;
        if (from.longValue() >= upperLimit) {
            throw new IllegalArgumentException("Lower bound (%s) >= upper bound-1 (%s)".formatted(from, upperLimit));
        }
        return new Range<T>(new Bound<T>(from, End.EXCLUSIVE), new Bound<T>(to, End.EXCLUSIVE));
    }

    public static <T extends Comparable<T>> Range<T> exclusiveInclusive(T from, T to) {
        if (from.compareTo(to) >= 0) {
            throw new IllegalArgumentException("Lower bound (%s) >= upper bound (%s)".formatted(from, to));
        }
        return new Range<T>(new Bound<T>(from, End.EXCLUSIVE), new Bound<T>(to, End.INCLUSIVE));
    }

    public <V extends Comparable<V>> Range<V> cast(Function<T, V> caster) {
        return new Range<Comparable>(new Bound<Comparable>((Comparable)caster.apply((Comparable)this.from.value), this.from.end), new Bound<Comparable>((Comparable)caster.apply((Comparable)this.to.value), this.to.end));
    }

    public record Bound<T>(T value, End end) {
    }

    public static enum End {
        INCLUSIVE,
        EXCLUSIVE;

    }
}

