/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.datafaker.internal.helper.JavaNames;
import net.datafaker.internal.helper.LazyEvaluated;
import net.datafaker.service.FakeValuesContext;
import net.datafaker.service.FakeValuesInterface;
import net.datafaker.shaded.snakeyaml.Yaml;

public class FakeValues
implements FakeValuesInterface {
    private static final Map<FakeValuesContext, FakeValues> FAKE_VALUES_MAP = new ConcurrentHashMap<FakeValuesContext, FakeValues>();
    private final FakeValuesContext fakeValuesContext;
    private final LazyEvaluated<Map<String, Object>> values = new LazyEvaluated<Map>(() -> this.loadValues());

    private FakeValues(FakeValuesContext fakeValuesContext) {
        this.fakeValuesContext = fakeValuesContext;
    }

    static FakeValues of(FakeValuesContext fakeValuesContext) {
        return FAKE_VALUES_MAP.computeIfAbsent(fakeValuesContext, FakeValues::new);
    }

    @Override
    public Map<String, Object> get(String key) {
        return FakeValues.getMap(this.values.get(), key);
    }

    private Map<String, Object> loadFromUrl() {
        Map<String, Object> map;
        block9: {
            URL url = this.fakeValuesContext.getUrl();
            if (url == null) {
                return null;
            }
            InputStream stream = url.openStream();
            try {
                map = this.readFromStream(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read fake values from %s".formatted(url), e);
                }
            }
            stream.close();
        }
        return map;
    }

    private Map<String, Object> loadValues() {
        String[] paths;
        String[] stringArray;
        Map<String, Object> result = this.loadFromUrl();
        if (result != null) {
            return result;
        }
        Locale locale = this.fakeValuesContext.getLocale();
        String fileName = this.fakeValuesContext.getFilename();
        if (fileName.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "/" + locale.getLanguage() + ".yml";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "/" + locale.getLanguage() + "/" + fileName;
            stringArray3[1] = "/" + fileName + ".yml";
            stringArray = stringArray3;
            stringArray3[2] = "/" + locale.getLanguage() + ".yml";
        }
        for (String path : paths = stringArray) {
            block19: {
                try (InputStream stream = this.getClass().getResourceAsStream(path);){
                    if (stream != null) {
                        result = this.readFromStream(stream);
                        this.enrichMapWithJavaNames(result);
                        break block19;
                    }
                    try (InputStream stream2 = this.getClass().getClassLoader().getResourceAsStream(path);){
                        result = this.readFromStream(stream2);
                        this.enrichMapWithJavaNames(result);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read fake values from %s".formatted(path), e);
                }
            }
            if (result == null) continue;
            return result;
        }
        return Collections.emptyMap();
    }

    private void enrichMapWithJavaNames(Map<String, Object> result) {
        if (result != null) {
            HashMap<String, Object> map = null;
            for (Map.Entry<String, Object> entry : result.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (entry.getValue() instanceof Map) {
                    Map entryMap = (Map)entry.getValue();
                    HashMap nestedMap = new HashMap(entryMap.size());
                    for (Map.Entry e : entryMap.entrySet()) {
                        nestedMap.put(JavaNames.toJavaNames((String)e.getKey(), true), e.getValue());
                    }
                    entryMap.putAll(nestedMap);
                }
                if (!key.contains("_")) continue;
                if (map == null) {
                    map = new HashMap<String, Object>();
                }
                map.put(JavaNames.toJavaNames(key, false), value);
            }
            if (map != null) {
                result.putAll(map);
            }
        }
    }

    private Map<String, Object> readFromStream(InputStream stream) {
        if (stream == null) {
            return null;
        }
        Map valuesMap = new Yaml().loadAs(stream, Map.class);
        Map<String, Object> localeBased = FakeValues.getMap(valuesMap, this.fakeValuesContext.getLocale().getLanguage());
        if (localeBased == null) {
            localeBased = FakeValues.getMap(valuesMap, this.fakeValuesContext.getFilename());
        }
        return FakeValues.getMap(localeBased, "faker");
    }

    private static Map<String, Object> getMap(Map<String, Object> map, String key) {
        return (Map)map.get(key);
    }

    Set<String> getPaths() {
        return this.fakeValuesContext.getPath() != null ? Set.of(this.fakeValuesContext.getPath()) : FakeValues.keysOf(this.values.get());
    }

    private static Set<String> keysOf(Map<String, ?> map) {
        return map == null || map.isEmpty() ? null : map.keySet();
    }

    Locale getLocale() {
        return this.fakeValuesContext.getLocale();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FakeValues)) {
            return false;
        }
        FakeValues that = (FakeValues)o;
        return Objects.equals(this.fakeValuesContext, that.fakeValuesContext);
    }

    public int hashCode() {
        return Objects.hashCode(this.fakeValuesContext);
    }

    public String toString() {
        return "FakeValues{%s}".formatted(this.fakeValuesContext);
    }
}

