/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.sequence;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.datafaker.sequence.FakeSequence;
import net.datafaker.service.RandomService;

public class FakeStream<T>
extends FakeSequence<T> {
    private FakeStream(List<Supplier<T>> suppliers, int minLength, int maxLength, RandomService randomService, double nullRate) {
        super(suppliers, minLength, maxLength, randomService, nullRate);
    }

    @Override
    public Stream<T> get() {
        if (this.isInfinite()) {
            return Stream.generate(this::singleton);
        }
        int size = this.randomService.nextInt(this.minLength, this.maxLength);
        return Stream.generate(this::singleton).limit(size);
    }

    @Override
    public boolean isInfinite() {
        return this.maxLength < 0;
    }

    @Override
    public Iterator<T> iterator() {
        return this.get().iterator();
    }

    public String toString() {
        return "FakeStream{minLength=%d, maxLength=%d, nullRate=%s}".formatted(this.minLength, this.maxLength, this.nullRate);
    }

    public static class Builder<T>
    extends FakeSequence.Builder<T> {
        public Builder() {
        }

        public Builder(List<Supplier<T>> list) {
            super(list);
        }

        @SafeVarargs
        public Builder(Supplier<T> ... elems) {
            super(elems);
        }

        @Override
        public FakeStream<T> build() {
            if (this.maxLength >= 0 && this.minLength > this.maxLength) {
                throw new IllegalArgumentException("Max length (%s) must be not less than min length (%s) and not negative".formatted(this.maxLength, this.minLength));
            }
            this.minLength = this.minLength < 0 ? this.maxLength : this.minLength;
            RandomService randomService = this.faker == null ? new RandomService() : this.faker.random();
            return new FakeStream(this.suppliers, this.minLength, this.maxLength, randomService, this.nullRate);
        }
    }
}

