/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.healthcare;

import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.healthcare.HealthcareProviders;

public class Disease
extends AbstractProvider<HealthcareProviders> {
    protected Disease(HealthcareProviders faker) {
        super(faker);
    }

    public String icd10() {
        return ((HealthcareProviders)this.faker).regexify(this.resolve("healthcare.disease.icd10"));
    }

    public String anyDisease() {
        return this.resolve(((HealthcareProviders)this.faker).options().option(DiseaseType.class));
    }

    public String internalDisease() {
        return this.resolve(DiseaseType.INTERNAL_DISEASE_KEY);
    }

    public String neurology() {
        return this.resolve(DiseaseType.NEUROLOGICAL_DISEASE_KEY);
    }

    public String surgery() {
        return this.resolve(DiseaseType.SURGICAL_DISEASE_KEY);
    }

    public String paediatrics() {
        return this.resolve(DiseaseType.PAEDIATRIC_DISEASE_KEY);
    }

    public String gynecologyAndObstetrics() {
        return this.resolve(DiseaseType.GYNECOLOGY_AND_OBSTETRICS_DISEASE_KEY);
    }

    public String ophthalmologyAndOtorhinolaryngology() {
        return this.resolve(DiseaseType.OPHTHALMOLOGY_AND_OTORHINOLARYNGOLOGY_DISEASE_KEY);
    }

    public String dermatology() {
        return this.resolve(DiseaseType.DERMATOLOGY_DISEASE_KEY);
    }

    private String resolve(DiseaseType diseaseType) {
        return this.resolve(diseaseType.yamlKey);
    }

    public static enum DiseaseType {
        INTERNAL_DISEASE_KEY("healthcare.disease.internal_disease"),
        NEUROLOGICAL_DISEASE_KEY("healthcare.disease.neurology"),
        SURGICAL_DISEASE_KEY("healthcare.disease.surgery"),
        PAEDIATRIC_DISEASE_KEY("healthcare.disease.paediatrics"),
        GYNECOLOGY_AND_OBSTETRICS_DISEASE_KEY("healthcare.disease.gynecology_and_obstetrics"),
        OPHTHALMOLOGY_AND_OTORHINOLARYNGOLOGY_DISEASE_KEY("healthcare.disease.ophthalmology_and_otorhinolaryngology"),
        DERMATOLOGY_DISEASE_KEY("healthcare.disease.dermatology");

        final String yamlKey;

        private DiseaseType(String yamlKey) {
            this.yamlKey = yamlKey;
        }
    }
}

