/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Vehicle
extends AbstractProvider<BaseProviders> {
    static final String VIN_REGEX = "([A-HJ-NPR-Z0-9]){3}[A-HJ-NPR-Z0-9]{5}[A-HJ-NPR-Z0-9]{1}[A-HJ-NPR-Z0-9]{1}[A-HJ-NPR-Z0-0]{1}[A-HJ-NPR-Z0-9]{1}\\d{5}";

    public Vehicle(BaseProviders faker) {
        super(faker);
    }

    public String vin() {
        return ((BaseProviders)this.faker).regexify(VIN_REGEX);
    }

    public String manufacturer() {
        return this.resolve("vehicle.manufacture");
    }

    public String make() {
        return this.resolve("vehicle.makes");
    }

    public String model() {
        return this.model(this.make());
    }

    public String model(String make) {
        return this.resolve("vehicle.models_by_make." + make);
    }

    public String makeAndModel() {
        String make = this.make();
        return make + " " + this.model(make);
    }

    public String style() {
        return this.resolve("vehicle.styles");
    }

    public String color() {
        return this.resolve("vehicle.colors");
    }

    public String upholsteryColor() {
        return this.resolve("vehicle.upholstery_colors");
    }

    public String upholsteryFabric() {
        return this.resolve("vehicle.upholstery_fabrics");
    }

    public String upholstery() {
        return this.resolve("vehicle.upholsteries");
    }

    public String transmission() {
        return this.resolve("vehicle.transmissions");
    }

    public String driveType() {
        return this.resolve("vehicle.drive_types");
    }

    public String fuelType() {
        return this.resolve("vehicle.fuel_types");
    }

    public String carType() {
        return this.resolve("vehicle.car_types");
    }

    public String engine() {
        return this.resolve("vehicle.engine_sizes") + " " + this.resolve("vehicle.cylinder_engine");
    }

    public List<String> carOptions() {
        return this.carOptions(5, 10);
    }

    public List<String> carOptions(int min, int max) {
        int optionSize;
        ArrayList<String> arr = new ArrayList<String>(optionSize);
        for (optionSize = ((BaseProviders)this.faker).number().numberBetween(min, max); optionSize > 0; --optionSize) {
            arr.add(((BaseProviders)this.faker).resolve("vehicle.car_options"));
        }
        return arr;
    }

    public List<String> standardSpecs() {
        return this.standardSpecs(5, 10);
    }

    public List<String> standardSpecs(int min, int max) {
        int standardSpecsSize;
        ArrayList<String> arr = new ArrayList<String>(standardSpecsSize);
        for (standardSpecsSize = ((BaseProviders)this.faker).number().numberBetween(min, max); standardSpecsSize > 0; --standardSpecsSize) {
            arr.add(((BaseProviders)this.faker).resolve("vehicle.standard_specs"));
        }
        return arr;
    }

    public String doors() {
        return this.resolve("vehicle.doors");
    }

    public String licensePlate() {
        return ((BaseProviders)this.faker).bothify(((BaseProviders)this.faker).resolve("vehicle.license_plate"));
    }

    public String licensePlate(String stateAbbreviation) {
        if ("".equals(stateAbbreviation)) {
            return null;
        }
        String licensePlatesByState = this.resolve("vehicle.license_plate_by_state." + stateAbbreviation);
        return licensePlatesByState == null ? null : ((BaseProviders)this.faker).bothify(licensePlatesByState).toUpperCase(Locale.ROOT);
    }
}

