/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Unique
extends AbstractProvider<BaseProviders> {
    private final Map<Locale, Map<String, List<String>>> valuesByKeyAndLocale = new HashMap<Locale, Map<String, List<String>>>();

    public Unique(BaseProviders faker) {
        super(faker);
    }

    public String fetchFromYaml(String key) {
        Locale locale = ((BaseProviders)this.faker).getContext().getLocale();
        Map valuesByKey = this.valuesByKeyAndLocale.getOrDefault(locale, new HashMap());
        List<String> values = (List<String>)valuesByKey.get(key);
        if (values == null) {
            values = this.fetchValues(key);
        }
        if (values.isEmpty()) {
            throw new NoSuchElementException("All possible values have been generated for key %s under locale %s".formatted(key, locale));
        }
        int index = ((BaseProviders)this.faker).random().nextInt(0, values.size() - 1);
        String value = this.removeAtIndex(values, index);
        valuesByKey.put(key, values);
        this.valuesByKeyAndLocale.put(locale, valuesByKey);
        return value;
    }

    private String removeAtIndex(List<String> values, int index) {
        int lastIndex = values.size() - 1;
        Collections.swap(values, index, lastIndex);
        return values.remove(lastIndex);
    }

    private List<String> fetchValues(String key) {
        Object object = ((BaseProviders)this.faker).fakeValuesService().fetchObject(key, ((BaseProviders)this.faker).getContext());
        if (!(object instanceof List)) {
            throw this.noValuesFoundException(key);
        }
        List<String> values = ((List)object).stream().filter(value -> !(value instanceof List)).map(String::valueOf).collect(Collectors.toList());
        if (values.isEmpty()) {
            throw this.noValuesFoundException(key);
        }
        return values;
    }

    private NoSuchElementException noValuesFoundException(String key) {
        return new NoSuchElementException("No values found for key %s".formatted(key));
    }
}

