/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Nation
extends AbstractProvider<BaseProviders> {
    private static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;

    protected Nation(BaseProviders faker) {
        super(faker);
    }

    public String nationality() {
        return this.resolve("nation.nationality");
    }

    public String language() {
        return this.resolve("nation.language");
    }

    public String capitalCity() {
        return this.resolve("nation.capital_city");
    }

    public String flag() {
        List flagInts = (List)((BaseProviders)this.faker).fakeValuesService().fetch("nation.flag", ((BaseProviders)this.faker).getContext());
        ByteBuffer byteBuffer = MappedByteBuffer.allocate(flagInts.size());
        for (Integer flagInt : flagInts) {
            byteBuffer.put(flagInt.byteValue());
        }
        return new String(byteBuffer.array(), UTF8_CHARSET);
    }

    public String isoLanguage() {
        String[] isoLangs = Locale.getISOLanguages();
        return isoLangs[((BaseProviders)this.faker).random().nextInt(isoLangs.length)];
    }

    public String isoCountry() {
        String[] isoCountries = Locale.getISOCountries();
        return isoCountries[((BaseProviders)this.faker).random().nextInt(isoCountries.length)];
    }
}

