/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.datafaker.internal.helper.FakerIDN;
import net.datafaker.internal.helper.LazyEvaluated;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Company
extends AbstractProvider<BaseProviders> {
    private final LazyEvaluated<List<String>> allBuzzwords = new LazyEvaluated<List>(() -> this.loadBuzzwords());

    protected Company(BaseProviders faker) {
        super(faker);
    }

    public String name() {
        return this.resolve("company.name");
    }

    public String suffix() {
        return this.resolve("company.suffix");
    }

    public String industry() {
        return this.resolve("company.industry");
    }

    public String profession() {
        return this.resolve("company.profession");
    }

    public String buzzword() {
        return ((BaseProviders)this.faker).options().nextElement(this.allBuzzwords.get());
    }

    private List<String> loadBuzzwords() {
        List buzzwordLists = (List)((BaseProviders)this.faker).fakeValuesService().fetchObject("company.buzzwords", ((BaseProviders)this.faker).getContext());
        return buzzwordLists.stream().flatMap(Collection::stream).toList();
    }

    public String catchPhrase() {
        List catchPhraseLists = (List)((BaseProviders)this.faker).fakeValuesService().fetchObject("company.buzzwords", ((BaseProviders)this.faker).getContext());
        return this.joinSampleOfEachList(catchPhraseLists);
    }

    public String bs() {
        List buzzwordLists = (List)((BaseProviders)this.faker).fakeValuesService().fetchObject("company.bs", ((BaseProviders)this.faker).getContext());
        return this.joinSampleOfEachList(buzzwordLists);
    }

    public String logo() {
        int number = ((BaseProviders)this.faker).random().nextInt(13) + 1;
        return "https://pigment.github.io/fake-logos/logos/medium/color/" + number + ".png";
    }

    public String url() {
        return "www." + FakerIDN.toASCII(this.domainName()) + "." + this.domainSuffix();
    }

    private String domainName() {
        char[] res = this.name().toLowerCase(((BaseProviders)this.faker).getContext().getLocale()).toCharArray();
        int offset = 0;
        block3: for (int i = 0; i < res.length; ++i) {
            char c = res[i];
            switch (c) {
                case ' ': 
                case '\'': 
                case ',': 
                case '.': 
                case ']': {
                    ++offset;
                    continue block3;
                }
                default: {
                    res[i - offset] = res[i];
                }
            }
        }
        return String.valueOf(res, 0, res.length - offset);
    }

    private String domainSuffix() {
        return this.resolve("internet.domain_suffix");
    }

    private String joinSampleOfEachList(List<List<String>> listOfLists) {
        return listOfLists.stream().map(list -> (String)((BaseProviders)this.faker).options().nextElement(list)).collect(Collectors.joining(" "));
    }
}

