/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.Text;

public class Aws
extends AbstractProvider<BaseProviders> {
    private final Text.TextRuleConfig configForRoute53ZoneId = Text.TextSymbolsBuilder.builder().with("ABCDEFGHIJKLMNOPQRSTUVWXYZ").len(21).build();

    protected Aws(BaseProviders faker) {
        super(faker);
    }

    public String region() {
        return this.resolve("aws.regions");
    }

    public String service() {
        return this.resolve("aws.services");
    }

    public String accountId() {
        return ((BaseProviders)this.faker).numerify("0#########");
    }

    public String acmARN() {
        return "arn:aws:acm:" + this.region() + ":" + this.accountId() + ":certificate/" + ((BaseProviders)this.faker).internet().uuid();
    }

    public String albARN() {
        return "arn:aws:elasticloadbalancing:" + this.region() + ":" + this.accountId() + ":loadbalancer/app/" + this.appName() + "/" + this.randHex();
    }

    public String albTargetGroupARN() {
        return "arn:aws:elasticloadbalancing:" + this.region() + ":" + this.accountId() + ":targetgroup/" + this.appName() + "/" + this.randHex();
    }

    public String route53ZoneId() {
        return ((BaseProviders)this.faker).text().text(this.configForRoute53ZoneId);
    }

    public String securityGroupId() {
        return "sg-" + this.randHex(17);
    }

    public String subnetId() {
        return "subnet-" + this.randHex(17);
    }

    public String vpcId() {
        return "vpc-" + this.randHex(17);
    }

    private String appName() {
        return ((BaseProviders)this.faker).app().name().toLowerCase().replaceAll("\\W+", "");
    }

    private String randHex(int length) {
        return ((BaseProviders)this.faker).random().hex(length, false);
    }

    private String randHex() {
        return this.randHex(16);
    }
}

