/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import net.datafaker.annotations.Deterministic;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Address
extends AbstractProvider<BaseProviders> {
    protected Address(BaseProviders faker) {
        super(faker);
    }

    public String streetName() {
        return this.resolve("address.street_name");
    }

    public String streetAddressNumber() {
        return String.valueOf(((BaseProviders)this.faker).random().nextInt(1000));
    }

    public String streetAddress() {
        return this.resolve("address.street_address");
    }

    public String streetAddress(boolean includeSecondary) {
        Object streetAddress = this.resolve("address.street_address");
        if (includeSecondary) {
            streetAddress = (String)streetAddress + " " + this.secondaryAddress();
        }
        return streetAddress;
    }

    public String secondaryAddress() {
        return ((BaseProviders)this.faker).numerify(this.resolve("address.secondary_address"));
    }

    public String zipCode() {
        return ((BaseProviders)this.faker).bothify(this.resolve("address.postcode"));
    }

    public String postcode() {
        return ((BaseProviders)this.faker).bothify(this.resolve("address.postcode"));
    }

    public String eircode() {
        return ((BaseProviders)this.faker).bothify(this.resolve("address.postcode"));
    }

    public String zipCodePlus4() {
        return ((BaseProviders)this.faker).bothify(this.resolve("address.postcode_plus_four"));
    }

    public String zipCodeByState(String stateAbbr) {
        return this.resolve("address.postcode_by_state." + stateAbbr);
    }

    public String countyByZipCode(String postCode) {
        return this.resolve("address.county_by_postcode." + postCode, () -> "County is not configured for postcode " + postCode);
    }

    public String streetSuffix() {
        return this.resolve("address.street_suffix");
    }

    @Deterministic
    public String streetPrefix() {
        return this.resolve("address.street_prefix");
    }

    public String citySuffix() {
        return this.resolve("address.city_suffix");
    }

    public String cityPrefix() {
        return this.resolve("address.city_prefix");
    }

    public String city() {
        return this.resolve("address.city");
    }

    public String cityName() {
        return this.resolve("address.city_name");
    }

    public String state() {
        return this.resolve("address.state");
    }

    public String stateAbbr() {
        return this.resolve("address.state_abbr");
    }

    public String latitude() {
        return String.format(((BaseProviders)this.faker).getContext().getLocale(), "%.8f", ((BaseProviders)this.faker).random().nextDouble() * 180.0 - 90.0);
    }

    public String longitude() {
        return String.format(((BaseProviders)this.faker).getContext().getLocale(), "%.8f", ((BaseProviders)this.faker).random().nextDouble() * 360.0 - 180.0);
    }

    public String latLon() {
        return this.latLon(",");
    }

    public String latLon(String delimiter) {
        return this.latitude() + delimiter + this.longitude();
    }

    public String lonLat() {
        return this.lonLat(",");
    }

    public String lonLat(String delimiter) {
        return this.longitude() + delimiter + this.latitude();
    }

    public String timeZone() {
        return this.resolve("address.time_zone");
    }

    public String country() {
        return this.resolve("address.country");
    }

    public String countryCode() {
        return this.resolve("address.country_code");
    }

    public String buildingNumber() {
        return ((BaseProviders)this.faker).numerify(this.resolve("address.building_number"));
    }

    public String fullAddress() {
        return this.resolve("address.full_address");
    }

    public String mailBox() {
        return ((BaseProviders)this.faker).numerify(this.resolve("address.mail_box"));
    }
}

