/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.internal.helper;

public class JavaNames {
    public static String toJavaNames(String string, boolean isMethod) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        int length = string.length();
        char[] res = new char[length];
        int pos = 0;
        Transform next = isMethod ? Transform.TO_LOWER : Transform.TO_UPPER;
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c)) {
                res[pos++] = next.transform(c);
                next = Transform.SAME;
                continue;
            }
            if (c == '_') {
                next = Transform.TO_UPPER;
                continue;
            }
            res[pos++] = c;
            next = Transform.SAME;
        }
        return new String(res, 0, pos);
    }

    static enum Transform {
        SAME,
        TO_LOWER,
        TO_UPPER;


        public char transform(char c) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SAME -> c;
                case TO_LOWER -> Character.toLowerCase(c);
                case TO_UPPER -> Character.toUpperCase(c);
            };
        }
    }
}

