/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class SwedenIdNumber
implements IdNumberGenerator {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyMMdd");
    private static final DateTimeFormatter FULL_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final String[] VALID_PATTERNS = new String[]{"######-####", "######+####"};

    @Override
    public String countryCode() {
        return "SE";
    }

    @Deprecated
    public String getValidSsn(BaseProviders f) {
        return this.generateValid(f);
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders f, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(f, request);
        String end = this.generateEndPart(f);
        String basePart = DATE_TIME_FORMATTER.format(birthday) + this.generateSymbol(birthday) + end;
        String idNumber = basePart + SwedenIdNumber.calculateChecksum(basePart);
        return new PersonIdNumber(idNumber, birthday, Utils.gender(f, request));
    }

    private String generateSymbol(LocalDate date) {
        return SwedenIdNumber.isYearOver100YearsAgo(date.toString().substring(0, 4), LocalDate.now()) ? "+" : "-";
    }

    private String generateEndPart(BaseProviders f) {
        return "%03d".formatted(f.number().numberBetween(1, 1000));
    }

    @Deprecated
    public String getInvalidSsn(BaseProviders f) {
        return this.generateInvalid(f);
    }

    @Override
    public String generateInvalid(BaseProviders f) {
        String candidate = "121212-1212";
        while (SwedenIdNumber.isValidSwedishSsn(candidate)) {
            String pattern = f.options().option(VALID_PATTERNS);
            candidate = f.numerify(pattern);
        }
        return candidate;
    }

    public static boolean isValidSwedishSsn(String ssn) {
        if (ssn.length() != 11) {
            return false;
        }
        try {
            if (SwedenIdNumber.isDateIncorrect(ssn)) {
                return false;
            }
        }
        catch (NumberFormatException | DateTimeParseException ignore) {
            return false;
        }
        if (ssn.startsWith("000", 7)) {
            return false;
        }
        int calculatedChecksum = SwedenIdNumber.calculateChecksum(ssn);
        int checksum = Integer.parseInt(ssn.substring(10, 11));
        return checksum == calculatedChecksum;
    }

    private static boolean isDateIncorrect(String ssn) {
        Object dateString = ssn.substring(0, 6);
        if (!ChronoField.YEAR.range().isValidIntValue(Integer.parseInt(((String)dateString).substring(0, 2)))) {
            return true;
        }
        if (!ChronoField.MONTH_OF_YEAR.range().isValidIntValue(Integer.parseInt(((String)dateString).substring(2, 4)))) {
            return true;
        }
        if (!ChronoField.DAY_OF_MONTH.range().isValidIntValue(Integer.parseInt(((String)dateString).substring(4)))) {
            return true;
        }
        dateString = SwedenIdNumber.findYearBeginningFromSsn(ssn) + (String)dateString;
        LocalDate date = LocalDate.parse((CharSequence)dateString, FULL_DATE_FORMATTER);
        String reversed = date.format(FULL_DATE_FORMATTER);
        return !reversed.equals(dateString);
    }

    static String findYearBeginningFromSsn(String ssn) {
        int startYear;
        char symbol = ssn.charAt(6);
        String yearEnd = ssn.substring(0, 2);
        for (int year = startYear = symbol == '+' ? LocalDate.now().minusYears(100L).getYear() - 1 : LocalDate.now().getYear(); year >= 0; --year) {
            if (!String.valueOf(year).endsWith(yearEnd)) continue;
            return String.valueOf(year).substring(0, 2);
        }
        String errorMessage = symbol == '+' ? "Cannot find year that ends with %s and is before %d".formatted(yearEnd, startYear + 1) : "Cannot find year that ends with %s".formatted(yearEnd);
        throw new RuntimeException(errorMessage);
    }

    static boolean isYearOver100YearsAgo(String year, LocalDate currentDate) {
        LocalDate hundredYearsAgo = currentDate.minusYears(100L);
        return LocalDate.of(Integer.parseInt(year), 1, 1).isBefore(hundredYearsAgo);
    }

    private static int calculateChecksum(String number) {
        String dateString = number.substring(0, 6);
        String birthNumber = number.substring(7, 10);
        String calculatedNumber = SwedenIdNumber.calculateDigits(dateString + birthNumber);
        int sum = SwedenIdNumber.calculateDigitSum(calculatedNumber);
        int lastDigit = sum % 10;
        int difference = 10 - lastDigit;
        return difference % 10;
    }

    private static String calculateDigits(String numbers) {
        StringBuilder calculatedNumbers = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            int n = numbers.charAt(i) - 48;
            int res = i % 2 == 0 ? n << 1 : n;
            calculatedNumbers.append(res);
        }
        return calculatedNumbers.toString();
    }

    private static int calculateDigitSum(String numbers) {
        int sum = 0;
        int length = numbers.length();
        for (int i = 0; i < length; ++i) {
            int n = numbers.charAt(i) - 48;
            sum += n;
        }
        return sum;
    }
}

