/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class SouthKoreanIdNumber
implements IdNumberGenerator {
    @Override
    public String countryCode() {
        return "KR";
    }

    @Deprecated
    public String getValidRrn(BaseProviders f) {
        return this.generateValid(f);
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders f, IdNumber.IdNumberRequest request) {
        StringBuilder patternBuilder = new StringBuilder();
        LocalDate birthday = Utils.birthday(f, request);
        String iso = f.nation().isoCountry();
        PersonIdNumber.Gender gender = Utils.gender(f, request);
        patternBuilder.append(this.generateDay(birthday));
        patternBuilder.append('-');
        patternBuilder.append(this.get7thDigit(birthday.getYear(), gender, iso));
        patternBuilder.append("######");
        String idNumber = f.numerify(patternBuilder.toString());
        return new PersonIdNumber(idNumber, birthday, gender);
    }

    private int get7thDigit(int year, PersonIdNumber.Gender gender, String isoCountry) {
        int locality;
        int n = locality = isoCountry.equalsIgnoreCase("kr") ? 1 : 5;
        if (year < 1900) {
            return gender == PersonIdNumber.Gender.MALE ? 9 : 0;
        }
        if (year < 2000) {
            return locality + (gender == PersonIdNumber.Gender.MALE ? 0 : 1);
        }
        return locality + (gender == PersonIdNumber.Gender.MALE ? 2 : 3);
    }

    private String generateDay(LocalDate birthday) {
        int year = birthday.getYear() % 100;
        int month = birthday.getMonthValue();
        int day = birthday.getDayOfMonth();
        char[] res = new char[]{(char)(48 + year / 10), (char)(48 + year % 10), (char)(48 + month / 10), (char)(48 + month % 10), (char)(48 + day / 10), (char)(48 + day % 10)};
        return String.valueOf(res);
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        return this.generateValid(faker) + "42";
    }
}

