/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class PolishIdNumber
implements IdNumberGenerator {
    public static final int PESEL_LENGTH = 11;

    @Override
    public String countryCode() {
        return "PL";
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(faker, request);
        PersonIdNumber.Gender gender = Utils.gender(faker, request);
        return new PersonIdNumber(this.get(faker, birthday, gender), birthday, gender);
    }

    @Deprecated
    public String get(BaseProviders faker, LocalDate birthDate, Gender requestedGender) {
        PersonIdNumber.Gender gender = PolishIdNumber.pickGender(faker, requestedGender);
        return this.get(faker, birthDate, gender);
    }

    private static PersonIdNumber.Gender pickGender(BaseProviders faker, Gender requestedGender) {
        PersonIdNumber.Gender gender;
        if (requestedGender == null) {
            gender = Utils.randomGender(faker);
        } else {
            switch (requestedGender) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ANY: {
                    gender = Utils.randomGender(faker);
                    break;
                }
                case MALE: {
                    gender = PersonIdNumber.Gender.MALE;
                    break;
                }
                case FEMALE: {
                    gender = PersonIdNumber.Gender.FEMALE;
                }
            }
        }
        return gender;
    }

    private String get(BaseProviders faker, LocalDate birthDate, PersonIdNumber.Gender gender) {
        int[] digits = this.generateDigits(faker, birthDate, gender);
        int controlDigit = this.getControlDigit(digits);
        return PolishIdNumber.toString(digits, controlDigit);
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        PersonIdNumber.Gender gender = Utils.randomGender(faker);
        int[] digits = this.generateDigits(faker, faker.timeAndDate().birthday(), gender);
        int controlDigit = this.getControlDigit(digits);
        int invalidControlDigit = (controlDigit + 1) % 10;
        return PolishIdNumber.toString(digits, invalidControlDigit);
    }

    private int[] generateDigits(BaseProviders faker, LocalDate birthDate, PersonIdNumber.Gender gender) {
        int monthEncoded = this.getMonthEncoded(birthDate.getYear(), birthDate.getMonthValue());
        return new int[]{birthDate.getYear() / 10 % 10, birthDate.getYear() % 10, monthEncoded / 10, monthEncoded % 10, birthDate.getDayOfMonth() / 10, birthDate.getDayOfMonth() % 10, this.randomDigit(faker), this.randomDigit(faker), this.randomDigit(faker), this.getGenderDigit(faker, gender)};
    }

    private static String toString(int[] digits, int controlDigit) {
        StringBuilder peselSb = new StringBuilder(11);
        for (int digit : digits) {
            peselSb.append(digit);
        }
        peselSb.append(controlDigit);
        return peselSb.toString();
    }

    private int randomDigit(BaseProviders faker) {
        return faker.number().randomDigit();
    }

    private int getControlDigit(int[] digits) {
        int sum = digits[0] + digits[4] + digits[8] + (digits[1] + digits[5] + digits[9]) * 3 + (digits[2] + digits[6]) * 7 + (digits[3] + digits[7]) * 9;
        return (10 - sum % 10) % 10;
    }

    private int getGenderDigit(BaseProviders faker, PersonIdNumber.Gender gender) {
        return switch (gender) {
            default -> throw new IncompatibleClassChangeError();
            case PersonIdNumber.Gender.FEMALE -> faker.random().nextInt(5) * 2;
            case PersonIdNumber.Gender.MALE -> faker.random().nextInt(5) * 2 + 1;
        };
    }

    private int getMonthEncoded(int year, int month) {
        int monthModifier;
        if (year < 1800) {
            throw new IllegalArgumentException("Year is before 1800: " + year);
        }
        if (year < 1900) {
            monthModifier = 80;
        } else if (year < 2000) {
            monthModifier = 0;
        } else if (year < 2100) {
            monthModifier = 20;
        } else if (year < 2200) {
            monthModifier = 40;
        } else if (year < 2300) {
            monthModifier = 60;
        } else {
            throw new IllegalArgumentException("Year is after 2300: " + year);
        }
        return month + monthModifier;
    }

    @Deprecated
    public static enum Gender {
        MALE,
        FEMALE,
        ANY;

    }
}

