/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.util.Locale;
import java.util.Map;
import java.util.stream.IntStream;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.LatinLetters;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;
import net.datafaker.providers.base.Text;

public class ItalianIdNumber
implements IdNumberGenerator {
    private static final String REGION_CODE_FIRST_LETTERS = "ABCDEFGHIJKLM";
    private static final String MONTH_LETTER = "_ABCDEHLMPRST";
    private static final Map<Character, Integer> ODD_CHARACTERS = Map.ofEntries(Map.entry(Character.valueOf('0'), 1), Map.entry(Character.valueOf('C'), 5), Map.entry(Character.valueOf('O'), 11), Map.entry(Character.valueOf('1'), 0), Map.entry(Character.valueOf('D'), 7), Map.entry(Character.valueOf('P'), 3), Map.entry(Character.valueOf('2'), 5), Map.entry(Character.valueOf('E'), 9), Map.entry(Character.valueOf('Q'), 6), Map.entry(Character.valueOf('3'), 7), Map.entry(Character.valueOf('F'), 13), Map.entry(Character.valueOf('R'), 8), Map.entry(Character.valueOf('4'), 9), Map.entry(Character.valueOf('G'), 15), Map.entry(Character.valueOf('S'), 12), Map.entry(Character.valueOf('5'), 13), Map.entry(Character.valueOf('H'), 17), Map.entry(Character.valueOf('T'), 14), Map.entry(Character.valueOf('6'), 15), Map.entry(Character.valueOf('I'), 19), Map.entry(Character.valueOf('U'), 16), Map.entry(Character.valueOf('7'), 17), Map.entry(Character.valueOf('J'), 21), Map.entry(Character.valueOf('V'), 10), Map.entry(Character.valueOf('8'), 19), Map.entry(Character.valueOf('K'), 2), Map.entry(Character.valueOf('W'), 22), Map.entry(Character.valueOf('9'), 21), Map.entry(Character.valueOf('L'), 4), Map.entry(Character.valueOf('X'), 25), Map.entry(Character.valueOf('A'), 1), Map.entry(Character.valueOf('M'), 18), Map.entry(Character.valueOf('Y'), 24), Map.entry(Character.valueOf('B'), 0), Map.entry(Character.valueOf('N'), 20), Map.entry(Character.valueOf('Z'), 23));
    private static final Map<Character, Integer> EVEN_CHARACTERS = Map.ofEntries(Map.entry(Character.valueOf('0'), 0), Map.entry(Character.valueOf('C'), 2), Map.entry(Character.valueOf('O'), 14), Map.entry(Character.valueOf('1'), 1), Map.entry(Character.valueOf('D'), 3), Map.entry(Character.valueOf('P'), 15), Map.entry(Character.valueOf('2'), 2), Map.entry(Character.valueOf('E'), 4), Map.entry(Character.valueOf('Q'), 16), Map.entry(Character.valueOf('3'), 3), Map.entry(Character.valueOf('F'), 5), Map.entry(Character.valueOf('R'), 17), Map.entry(Character.valueOf('4'), 4), Map.entry(Character.valueOf('G'), 6), Map.entry(Character.valueOf('S'), 18), Map.entry(Character.valueOf('5'), 5), Map.entry(Character.valueOf('H'), 7), Map.entry(Character.valueOf('T'), 19), Map.entry(Character.valueOf('6'), 6), Map.entry(Character.valueOf('I'), 8), Map.entry(Character.valueOf('U'), 20), Map.entry(Character.valueOf('7'), 7), Map.entry(Character.valueOf('J'), 9), Map.entry(Character.valueOf('V'), 21), Map.entry(Character.valueOf('8'), 8), Map.entry(Character.valueOf('K'), 10), Map.entry(Character.valueOf('W'), 22), Map.entry(Character.valueOf('9'), 9), Map.entry(Character.valueOf('L'), 11), Map.entry(Character.valueOf('X'), 23), Map.entry(Character.valueOf('A'), 0), Map.entry(Character.valueOf('M'), 12), Map.entry(Character.valueOf('Y'), 24), Map.entry(Character.valueOf('B'), 1), Map.entry(Character.valueOf('N'), 13), Map.entry(Character.valueOf('Z'), 25));
    private static final Map<Integer, Character> DIVISION_REST = Map.ofEntries(Map.entry(0, Character.valueOf('A')), Map.entry(10, Character.valueOf('K')), Map.entry(20, Character.valueOf('U')), Map.entry(1, Character.valueOf('B')), Map.entry(11, Character.valueOf('L')), Map.entry(21, Character.valueOf('V')), Map.entry(2, Character.valueOf('C')), Map.entry(12, Character.valueOf('M')), Map.entry(22, Character.valueOf('W')), Map.entry(3, Character.valueOf('D')), Map.entry(13, Character.valueOf('N')), Map.entry(23, Character.valueOf('X')), Map.entry(4, Character.valueOf('E')), Map.entry(14, Character.valueOf('O')), Map.entry(24, Character.valueOf('Y')), Map.entry(5, Character.valueOf('F')), Map.entry(15, Character.valueOf('P')), Map.entry(25, Character.valueOf('Z')), Map.entry(6, Character.valueOf('G')), Map.entry(16, Character.valueOf('Q')), Map.entry(7, Character.valueOf('H')), Map.entry(17, Character.valueOf('R')), Map.entry(8, Character.valueOf('I')), Map.entry(18, Character.valueOf('S')), Map.entry(9, Character.valueOf('J')), Map.entry(19, Character.valueOf('T')));

    @Override
    public String countryCode() {
        return "IT";
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(faker, request);
        PersonIdNumber.Gender gender = Utils.gender(faker, request);
        String firstName = faker.name().firstName().toUpperCase(Locale.ROOT);
        String lastName = faker.name().lastName().toUpperCase(Locale.ROOT);
        String basePart = this.encodeName(firstName) + this.encodeName(lastName) + this.encodeYear(birthday) + this.encodeMonth(birthday) + this.encodeDayAndGender(birthday, gender) + this.encodeRegion(faker);
        return new PersonIdNumber(basePart + this.checksum(basePart), birthday, gender);
    }

    String encodeName(String name) {
        String latinLetters = LatinLetters.removeNonLatinLetters(name);
        IntStream consonants = latinLetters.chars().filter(c -> LatinLetters.isConsonant(c));
        IntStream vowels = latinLetters.chars().filter(c -> !LatinLetters.isConsonant(c));
        IntStream placeholder = "XXX".chars();
        return Utils.join(consonants, vowels, placeholder, 3);
    }

    private String encodeYear(LocalDate birthday) {
        return String.valueOf(birthday.getYear()).substring(2);
    }

    private char encodeMonth(LocalDate birthday) {
        return MONTH_LETTER.charAt(birthday.getMonthValue());
    }

    private String encodeDayAndGender(LocalDate birthday, PersonIdNumber.Gender gender) {
        int day = switch (gender) {
            default -> throw new IncompatibleClassChangeError();
            case PersonIdNumber.Gender.FEMALE -> 40 + birthday.getDayOfMonth();
            case PersonIdNumber.Gender.MALE -> birthday.getDayOfMonth();
        };
        return "%02d".formatted(day);
    }

    private String encodeRegion(BaseProviders faker) {
        String regionLetter = faker.text().text(Text.TextSymbolsBuilder.builder().len(1).with(REGION_CODE_FIRST_LETTERS).build());
        return "%s%03d".formatted(regionLetter, faker.number().numberBetween(1, 1000));
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        String valid = this.generateValid(faker);
        return valid.substring(0, valid.length() - 1) + "9";
    }

    char checksum(String basePart) {
        int i;
        int sum = 0;
        for (i = 0; i < basePart.length(); i += 2) {
            sum += ODD_CHARACTERS.get(Character.valueOf(basePart.charAt(i))).intValue();
        }
        for (i = 1; i < basePart.length(); i += 2) {
            sum += EVEN_CHARACTERS.get(Character.valueOf(basePart.charAt(i))).intValue();
        }
        return DIVISION_REST.get(sum % 26).charValue();
    }
}

