/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class EstonianIdNumber
implements IdNumberGenerator {
    private static final DateTimeFormatter BIRTHDAY_FORMAT = DateTimeFormatter.ofPattern("yyMMdd");
    private static final int[] CHECKSUM_COEFFICIENTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 1};
    private static final int[] CHECKSUM_COEFFICIENTS2 = new int[]{3, 4, 5, 6, 7, 8, 9, 1, 2, 3};

    @Override
    public String countryCode() {
        return "EE";
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        LocalDate birthday = faker.timeAndDate().birthday();
        String digits = this.basePart(faker, birthday, Utils.randomGender(faker));
        return digits + (EstonianIdNumber.checksum(digits) + 1) % 10;
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(faker, request);
        PersonIdNumber.Gender gender = Utils.gender(faker, request);
        String digits = this.basePart(faker, birthday, gender);
        String idNumber = digits + EstonianIdNumber.checksum(digits);
        return new PersonIdNumber(idNumber, birthday, gender);
    }

    private String basePart(BaseProviders faker, LocalDate birthday, PersonIdNumber.Gender gender) {
        return EstonianIdNumber.firstDigit(birthday.getYear(), gender) + BIRTHDAY_FORMAT.format(birthday) + faker.number().digits(3);
    }

    static int firstDigit(int birthYear, PersonIdNumber.Gender gender) {
        int digit = switch (birthYear / 100) {
            case 18 -> 1;
            case 19 -> 3;
            case 20 -> 5;
            case 21 -> 7;
            default -> throw new IllegalStateException("Birth year %s is out of allowed range [1800, 2199]".formatted(birthYear));
        };
        return switch (gender) {
            default -> throw new IncompatibleClassChangeError();
            case PersonIdNumber.Gender.FEMALE -> digit + 1;
            case PersonIdNumber.Gender.MALE -> digit;
        };
    }

    static int checksum(String numbers) {
        int checksum = EstonianIdNumber.checksum(numbers, CHECKSUM_COEFFICIENTS);
        return checksum != 10 ? checksum : EstonianIdNumber.checksum(numbers, CHECKSUM_COEFFICIENTS2) % 10;
    }

    private static int checksum(String numbers, int[] checksumCoefficients) {
        int checkSum = 0;
        for (int i = 0; i < numbers.length(); ++i) {
            int digit = Character.getNumericValue(numbers.charAt(i));
            checkSum += checksumCoefficients[i] * digit;
        }
        return checkSum % 11;
    }
}

