/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.domestic.extractor;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.domestic.extractor.ToLongDocumentExtractor;
import net.openhft.chronicle.wire.internal.extractor.DocumentExtractorBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface DocumentExtractor<T> {
    @Nullable
    public T extract(@NotNull Wire var1, @NonNegative long var2) throws InvalidMarshallableException;

    default public <R> DocumentExtractor<R> map(@NotNull Function<? super T, ? extends R> mapper) {
        ObjectUtils.requireNonNull(mapper);
        return (wire, index) -> {
            T value = this.extract(wire, index);
            if (value == null) {
                return null;
            }
            return mapper.apply((T)value);
        };
    }

    default public ToLongDocumentExtractor mapToLong(@NotNull ToLongFunction<? super T> mapper) {
        ObjectUtils.requireNonNull(mapper);
        return (wire, index) -> {
            T value = this.extract(wire, index);
            if (value == null) {
                return Long.MIN_VALUE;
            }
            return mapper.applyAsLong((T)value);
        };
    }

    default public DocumentExtractor<T> filter(@NotNull Predicate<? super T> predicate) {
        ObjectUtils.requireNonNull(predicate);
        return (wire, index) -> {
            T value = this.extract(wire, index);
            if (value == null) {
                return null;
            }
            return predicate.test((T)value) ? value : null;
        };
    }

    public static <E> Builder<E> builder(@NotNull Class<E> elementType) {
        ObjectUtils.requireNonNull(elementType);
        return new DocumentExtractorBuilder<E>(elementType);
    }

    public static interface Builder<E>
    extends net.openhft.chronicle.core.util.Builder<DocumentExtractor<E>> {
        @NotNull
        public Builder<E> withReusing(@NotNull Supplier<? extends E> var1);

        @NotNull
        public Builder<E> withThreadConfinedReuse();

        @NotNull
        public <I> Builder<E> withMethod(@NotNull Class<I> var1, @NotNull BiConsumer<? super I, ? super E> var2);
    }
}

