/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.time.LongTime;
import net.openhft.chronicle.wire.AbstractTimestampLongConverter;

public class MilliTimestampLongConverter
extends AbstractTimestampLongConverter {
    public static final MilliTimestampLongConverter INSTANCE = new MilliTimestampLongConverter();

    public MilliTimestampLongConverter() {
        super(TimeUnit.MILLISECONDS);
    }

    public MilliTimestampLongConverter(String zoneId) {
        super(zoneId, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public MilliTimestampLongConverter(String zoneId, boolean includeZoneSuffixForUTC) {
        super(zoneId, TimeUnit.MILLISECONDS, includeZoneSuffixForUTC);
    }

    @Override
    protected long parseFormattedDate(ZonedDateTime value) {
        long time = value.getLong(ChronoField.EPOCH_DAY) * 86400000L;
        if (value.isSupported(ChronoField.MILLI_OF_DAY)) {
            time += value.getLong(ChronoField.MILLI_OF_DAY);
        } else if (value.isSupported(ChronoField.SECOND_OF_DAY)) {
            time += value.getLong(ChronoField.SECOND_OF_DAY) * 1000L;
        }
        return time;
    }

    @Override
    protected long parseTimestamp(long value, CharSequence text) {
        long number = LongTime.toMillis(value);
        if (LongTime.isMillis(number)) {
            Jvm.debug().on(this.getClass(), "In input data, replace " + text + " with " + this.asString(number));
        } else if (number != 0L) {
            Jvm.debug().on(this.getClass(), "In input data, replace " + text + " with a real date.");
        }
        return number;
    }

    @Override
    protected void appendFraction(DateTimeFormatterBuilder builder) {
        builder.appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true);
    }
}

