/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.ExceptionUtils;
import org.apache.kafka.streams.state.internals.FilteredCacheIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheWindowStoreIterator;
import org.apache.kafka.streams.state.internals.MergedSortedCacheWindowStoreKeyValueIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeOrderedCachingWindowStore
extends WrappedStateStore<WindowStore<Bytes, byte[]>, byte[], byte[]>
implements WindowStore<Bytes, byte[]>,
CachedStateStore<byte[], byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(TimeOrderedCachingWindowStore.class);
    private final long windowSize;
    private final SegmentedCacheFunction baseKeyCacheFunction;
    private final SegmentedCacheFunction indexKeyCacheFunction;
    private final PrefixedWindowKeySchemas.TimeFirstWindowKeySchema baseKeySchema = new PrefixedWindowKeySchemas.TimeFirstWindowKeySchema();
    private final PrefixedWindowKeySchemas.KeyFirstWindowKeySchema indexKeySchema = new PrefixedWindowKeySchemas.KeyFirstWindowKeySchema();
    private String cacheName;
    private boolean hasIndex;
    private boolean sendOldValues;
    private InternalProcessorContext<?, ?> internalContext;
    private StateSerdes<Bytes, byte[]> bytesSerdes;
    private CacheFlushListener<byte[], byte[]> flushListener;
    private final AtomicLong maxObservedTimestamp;

    TimeOrderedCachingWindowStore(WindowStore<Bytes, byte[]> underlying, long windowSize, long segmentInterval) {
        super(underlying);
        this.windowSize = windowSize;
        this.baseKeyCacheFunction = new SegmentedCacheFunction(this.baseKeySchema, segmentInterval);
        this.indexKeyCacheFunction = new SegmentedCacheFunction(this.indexKeySchema, segmentInterval);
        this.maxObservedTimestamp = new AtomicLong(-1L);
        this.enforceWrappedStore(underlying);
    }

    private void enforceWrappedStore(WindowStore<Bytes, byte[]> underlying) {
        RocksDBTimeOrderedWindowStore timeOrderedWindowStore = this.getWrappedStore(underlying);
        if (timeOrderedWindowStore == null) {
            throw new IllegalArgumentException("TimeOrderedCachingWindowStore only supports RocksDBTimeOrderedWindowStore backed store");
        }
        this.hasIndex = timeOrderedWindowStore.hasIndex();
    }

    private RocksDBTimeOrderedWindowStore getWrappedStore(StateStore wrapped) {
        if (wrapped instanceof RocksDBTimeOrderedWindowStore) {
            return (RocksDBTimeOrderedWindowStore)wrapped;
        }
        if (wrapped instanceof WrappedStateStore) {
            return this.getWrappedStore((StateStore)((WrappedStateStore)wrapped).wrapped());
        }
        return null;
    }

    @Override
    public void init(StateStoreContext stateStoreContext, StateStore root) {
        String prefix = StreamsConfig.InternalConfig.getString(stateStoreContext.appConfigs(), "__internal.override.topic.prefix__", stateStoreContext.applicationId());
        this.internalContext = ProcessorContextUtils.asInternalProcessorContext(stateStoreContext);
        String topic = ProcessorStateManager.storeChangelogTopic(prefix, this.name(), stateStoreContext.taskId().topologyName());
        this.bytesSerdes = new StateSerdes<Bytes, byte[]>(topic, Serdes.Bytes(), Serdes.ByteArray());
        this.cacheName = String.valueOf(stateStoreContext.taskId()) + "-" + this.name();
        this.internalContext.registerCacheFlushListener(this.cacheName, entries -> this.putAndMaybeForward(entries, this.internalContext));
        super.init(stateStoreContext, root);
    }

    private void putAndMaybeForward(List<ThreadCache.DirtyEntry> entries, InternalProcessorContext<?, ?> context) {
        HashSet<Bytes> processedBasedKey = new HashSet<Bytes>();
        for (ThreadCache.DirtyEntry entry : entries) {
            ThreadCache.DirtyEntry finalEntry;
            Bytes baseKey;
            byte[] binaryWindowKey = this.baseKeyCacheFunction.key(entry.key()).get();
            boolean isBaseKey = PrefixedWindowKeySchemas.isTimeFirstSchemaKey(binaryWindowKey);
            if (!isBaseKey) {
                baseKey = this.indexKeyToBaseKey(Bytes.wrap(binaryWindowKey));
                if (this.hasIndex && processedBasedKey.contains(baseKey)) continue;
                Bytes cachedBaseKey = this.baseKeyCacheFunction.cacheKey(baseKey);
                LRUCacheEntry value = context.cache().get(this.cacheName, cachedBaseKey);
                if (value == null) continue;
                finalEntry = new ThreadCache.DirtyEntry(entry.key(), value.value(), value);
                if (this.hasIndex) {
                    processedBasedKey.add(baseKey);
                }
            } else {
                baseKey = Bytes.wrap(binaryWindowKey);
                if (this.hasIndex && processedBasedKey.contains(baseKey)) continue;
                finalEntry = entry;
                if (this.hasIndex) {
                    processedBasedKey.add(Bytes.wrap(binaryWindowKey));
                }
            }
            Windowed<Bytes> windowedKeyBytes = isBaseKey ? PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.fromStoreBytesKey(binaryWindowKey, this.windowSize) : PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.fromStoreBytesKey(binaryWindowKey, this.windowSize);
            long windowStartTimestamp = windowedKeyBytes.window().start();
            Bytes binaryKey = windowedKeyBytes.key();
            this.putAndMaybeForward(context, finalEntry, binaryKey, windowStartTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndMaybeForward(InternalProcessorContext<?, ?> context, ThreadCache.DirtyEntry finalEntry, Bytes binaryKey, long windowStartTimestamp) {
        if (this.flushListener != null) {
            byte[] rawOldValue;
            byte[] rawNewValue = finalEntry.newValue();
            byte[] byArray = rawOldValue = rawNewValue == null || this.sendOldValues ? (byte[])((WindowStore)this.wrapped()).fetch(binaryKey, windowStartTimestamp) : null;
            if (rawNewValue != null || rawOldValue != null) {
                ProcessorRecordContext current = context.recordContext();
                try {
                    context.setRecordContext(finalEntry.entry().context());
                    ((WindowStore)this.wrapped()).put(binaryKey, finalEntry.newValue(), windowStartTimestamp);
                    this.flushListener.apply(new Record<byte[], Change<byte[]>>(WindowKeySchema.toStoreKeyBinary(binaryKey, windowStartTimestamp, 0).get(), new Change<byte[]>(rawNewValue, (byte[])(this.sendOldValues ? rawOldValue : null)), finalEntry.entry().context().timestamp(), finalEntry.entry().context().headers()));
                }
                finally {
                    context.setRecordContext(current);
                }
            }
        } else {
            ProcessorRecordContext current = context.recordContext();
            try {
                context.setRecordContext(finalEntry.entry().context());
                ((WindowStore)this.wrapped()).put(binaryKey, finalEntry.newValue(), windowStartTimestamp);
            }
            finally {
                context.setRecordContext(current);
            }
        }
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<byte[], byte[]> flushListener, boolean sendOldValues) {
        this.flushListener = flushListener;
        this.sendOldValues = sendOldValues;
        return true;
    }

    private Bytes indexKeyToBaseKey(Bytes indexKey) {
        byte[] key = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.extractStoreKeyBytes(indexKey.get());
        long timestamp = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.extractStoreTimestamp(indexKey.get());
        int seqnum = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.extractStoreSequence(indexKey.get());
        return PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary(key, timestamp, seqnum);
    }

    @Override
    public synchronized void put(Bytes key, byte[] value, long windowStartTimestamp) {
        this.validateStoreOpen();
        Bytes baseKeyBytes = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary(key, windowStartTimestamp, 0);
        LRUCacheEntry entry = new LRUCacheEntry(value, this.internalContext.headers(), true, this.internalContext.offset(), this.internalContext.timestamp(), this.internalContext.partition(), this.internalContext.topic(), this.internalContext.recordContext().sourceRawKey(), this.internalContext.recordContext().sourceRawValue());
        if (this.hasIndex) {
            this.internalContext.cache().put(this.cacheName, this.baseKeyCacheFunction.cacheKey(baseKeyBytes), entry);
            LRUCacheEntry emptyEntry = new LRUCacheEntry(new byte[0], new RecordHeaders(), true, this.internalContext.offset(), this.internalContext.timestamp(), this.internalContext.partition(), "", this.internalContext.recordContext().sourceRawKey(), this.internalContext.recordContext().sourceRawValue());
            Bytes indexKey = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.toStoreKeyBinary(key, windowStartTimestamp, 0);
            this.internalContext.cache().put(this.cacheName, this.indexKeyCacheFunction.cacheKey(indexKey), emptyEntry);
        } else {
            this.internalContext.cache().put(this.cacheName, this.baseKeyCacheFunction.cacheKey(baseKeyBytes), entry);
        }
        this.maxObservedTimestamp.set(Math.max(windowStartTimestamp, this.maxObservedTimestamp.get()));
    }

    @Override
    public byte[] fetch(Bytes key, long timestamp) {
        this.validateStoreOpen();
        if (this.internalContext.cache() == null) {
            return (byte[])((WindowStore)this.wrapped()).fetch(key, timestamp);
        }
        Bytes baseBytesKey = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary(key, timestamp, 0);
        Bytes cacheKey = this.baseKeyCacheFunction.cacheKey(baseBytesKey);
        LRUCacheEntry entry = this.internalContext.cache().get(this.cacheName, cacheKey);
        if (entry == null) {
            return (byte[])((WindowStore)this.wrapped()).fetch(key, timestamp);
        }
        return entry.value();
    }

    @Override
    public synchronized WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
        this.validateStoreOpen();
        WindowStoreIterator<byte[]> underlyingIterator = ((WindowStore)this.wrapped()).fetch(key, timeFrom, timeTo);
        if (this.internalContext.cache() == null) {
            return underlyingIterator;
        }
        return this.fetchInternal(underlyingIterator, key, timeFrom, timeTo, true);
    }

    @Override
    public synchronized WindowStoreIterator<byte[]> backwardFetch(Bytes key, long timeFrom, long timeTo) {
        this.validateStoreOpen();
        WindowStoreIterator<byte[]> underlyingIterator = ((WindowStore)this.wrapped()).backwardFetch(key, timeFrom, timeTo);
        if (this.internalContext.cache() == null) {
            return underlyingIterator;
        }
        return this.fetchInternal(underlyingIterator, key, timeFrom, timeTo, false);
    }

    private WindowStoreIterator<byte[]> fetchInternal(WindowStoreIterator<byte[]> underlyingIterator, Bytes key, long timeFrom, long timeTo, boolean forward) {
        CacheIteratorWrapper cacheIterator = new CacheIteratorWrapper(key, timeFrom, timeTo, forward, this.hasIndex);
        SegmentedBytesStore.KeySchema keySchema = this.hasIndex ? this.indexKeySchema : this.baseKeySchema;
        SegmentedCacheFunction cacheFunction = this.hasIndex ? this.indexKeyCacheFunction : this.baseKeyCacheFunction;
        HasNextCondition hasNextCondition = keySchema.hasNextCondition(key, key, timeFrom, timeTo, forward);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, cacheFunction);
        Function<byte[], Long> tsExtractor = this.hasIndex ? PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::extractStoreTimestamp : PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp;
        return new MergedSortedCacheWindowStoreIterator(filteredCacheIterator, underlyingIterator, forward, tsExtractor);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        if (keyFrom != null && keyTo != null && keyFrom.compareTo(keyTo) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        this.validateStoreOpen();
        KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator = ((WindowStore)this.wrapped()).fetch(keyFrom, keyTo, timeFrom, timeTo);
        if (this.internalContext.cache() == null) {
            return underlyingIterator;
        }
        return this.fetchKeyRange(underlyingIterator, keyFrom, keyTo, timeFrom, timeTo, true);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        if (keyFrom != null && keyTo != null && keyFrom.compareTo(keyTo) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        this.validateStoreOpen();
        KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator = ((WindowStore)this.wrapped()).backwardFetch(keyFrom, keyTo, timeFrom, timeTo);
        if (this.internalContext.cache() == null) {
            return underlyingIterator;
        }
        return this.fetchKeyRange(underlyingIterator, keyFrom, keyTo, timeFrom, timeTo, false);
    }

    private KeyValueIterator<Windowed<Bytes>, byte[]> fetchKeyRange(KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator, Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo, boolean forward) {
        CacheIteratorWrapper cacheIterator = new CacheIteratorWrapper(keyFrom, keyTo, timeFrom, timeTo, forward, this.hasIndex);
        SegmentedBytesStore.KeySchema keySchema = this.hasIndex ? this.indexKeySchema : this.baseKeySchema;
        HasNextCondition hasNextCondition = keySchema.hasNextCondition(keyFrom, keyTo, timeFrom, timeTo, forward);
        SegmentedCacheFunction cacheFunction = this.hasIndex ? this.indexKeyCacheFunction : this.baseKeyCacheFunction;
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, cacheFunction);
        MergedSortedCacheWindowStoreKeyValueIterator.StoreKeyToWindowKey storeKeyToWindowKey = this.hasIndex ? PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::fromStoreKey : PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreKey;
        MergedSortedCacheWindowStoreKeyValueIterator.WindowKeyToBytes windowKeyToBytes = this.hasIndex ? PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::toStoreKeyBinary : PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::toStoreKeyBinary;
        return new MergedSortedCacheWindowStoreKeyValueIterator(filteredCacheIterator, underlyingIterator, this.bytesSerdes, this.windowSize, cacheFunction, forward, storeKeyToWindowKey, windowKeyToBytes);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        this.validateStoreOpen();
        KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator = ((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo);
        return this.fetchAllInternal(underlyingIterator, timeFrom, timeTo, true);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetchAll(long timeFrom, long timeTo) {
        this.validateStoreOpen();
        KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator = ((WindowStore)this.wrapped()).backwardFetchAll(timeFrom, timeTo);
        return this.fetchAllInternal(underlyingIterator, timeFrom, timeTo, false);
    }

    private KeyValueIterator<Windowed<Bytes>, byte[]> fetchAllInternal(KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator, long timeFrom, long timeTo, boolean forward) {
        CacheIteratorWrapper cacheIterator = new CacheIteratorWrapper(null, null, timeFrom, timeTo, forward, false);
        HasNextCondition hasNextCondition = this.baseKeySchema.hasNextCondition(null, null, timeFrom, timeTo, forward);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, this.baseKeyCacheFunction);
        MergedSortedCacheWindowStoreKeyValueIterator.StoreKeyToWindowKey storeKeyToWindowKey = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreKey;
        MergedSortedCacheWindowStoreKeyValueIterator.WindowKeyToBytes windowKeyToBytes = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::toStoreKeyBinary;
        return new MergedSortedCacheWindowStoreKeyValueIterator(filteredCacheIterator, underlyingIterator, this.bytesSerdes, this.windowSize, this.baseKeyCacheFunction, forward, storeKeyToWindowKey, windowKeyToBytes);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        this.validateStoreOpen();
        KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator = ((WindowStore)this.wrapped()).all();
        return this.fetchAllInternal(underlyingIterator, 0L, Long.MAX_VALUE, true);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardAll() {
        this.validateStoreOpen();
        KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator = ((WindowStore)this.wrapped()).backwardAll();
        return this.fetchAllInternal(underlyingIterator, 0L, Long.MAX_VALUE, false);
    }

    @Override
    public synchronized void flush() {
        this.internalContext.cache().flush(this.cacheName);
        ((WindowStore)this.wrapped()).flush();
    }

    @Override
    public void flushCache() {
        this.internalContext.cache().flush(this.cacheName);
    }

    @Override
    public void clearCache() {
        this.internalContext.cache().clear(this.cacheName);
    }

    @Override
    public synchronized void close() {
        Runnable[] runnableArray = new Runnable[3];
        runnableArray[0] = () -> this.internalContext.cache().flush(this.cacheName);
        runnableArray[1] = () -> this.internalContext.cache().close(this.cacheName);
        runnableArray[2] = ((WindowStore)this.wrapped())::close;
        LinkedList<RuntimeException> suppressed = ExceptionUtils.executeAll(runnableArray);
        if (!suppressed.isEmpty()) {
            ExceptionUtils.throwSuppressed("Caught an exception while closing caching window store for store " + this.name(), suppressed);
        }
    }

    private class CacheIteratorWrapper
    implements PeekingKeyValueIterator<Bytes, LRUCacheEntry> {
        private final long segmentInterval;
        private final Bytes keyFrom;
        private final Bytes keyTo;
        private final long timeTo;
        private final boolean forward;
        private final boolean useIndex;
        private long lastSegmentId;
        private long currentSegmentId;
        private Bytes cacheKeyFrom;
        private Bytes cacheKeyTo;
        private LRUCacheEntry cachedBaseValue;
        private final SegmentedCacheFunction cacheFunction;
        private ThreadCache.MemoryLRUCacheBytesIterator current;

        private CacheIteratorWrapper(Bytes key, long timeFrom, long timeTo, boolean forward, boolean index) {
            this(key, key, timeFrom, timeTo, forward, index);
        }

        private CacheIteratorWrapper(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo, boolean forward, boolean index) {
            this.keyFrom = keyFrom;
            this.keyTo = keyTo;
            this.timeTo = timeTo;
            this.forward = forward;
            this.useIndex = index;
            this.cacheFunction = index ? TimeOrderedCachingWindowStore.this.indexKeyCacheFunction : TimeOrderedCachingWindowStore.this.baseKeyCacheFunction;
            this.segmentInterval = this.cacheFunction.getSegmentInterval();
            if (forward) {
                this.lastSegmentId = this.cacheFunction.segmentId(Math.min(timeTo, TimeOrderedCachingWindowStore.this.maxObservedTimestamp.get()));
                this.currentSegmentId = this.cacheFunction.segmentId(timeFrom);
                this.setCacheKeyRange(timeFrom, this.currentSegmentLastTime());
                this.current = TimeOrderedCachingWindowStore.this.internalContext.cache().range(TimeOrderedCachingWindowStore.this.cacheName, this.cacheKeyFrom, this.cacheKeyTo);
            } else {
                this.currentSegmentId = this.cacheFunction.segmentId(Math.min(timeTo, TimeOrderedCachingWindowStore.this.maxObservedTimestamp.get()));
                this.lastSegmentId = this.cacheFunction.segmentId(timeFrom);
                this.setCacheKeyRange(this.currentSegmentBeginTime(), Math.min(timeTo, TimeOrderedCachingWindowStore.this.maxObservedTimestamp.get()));
                this.current = TimeOrderedCachingWindowStore.this.internalContext.cache().reverseRange(TimeOrderedCachingWindowStore.this.cacheName, this.cacheKeyFrom, this.cacheKeyTo);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                return false;
            }
            if (this.useIndex) {
                while (true) {
                    if (this.current.hasNext()) {
                        Bytes cacheIndexKey = this.current.peekNextKey();
                        Bytes indexKey = TimeOrderedCachingWindowStore.this.indexKeyCacheFunction.key(cacheIndexKey);
                        Bytes baseKey = TimeOrderedCachingWindowStore.this.indexKeyToBaseKey(indexKey);
                        Bytes cachedBaseKey = TimeOrderedCachingWindowStore.this.baseKeyCacheFunction.cacheKey(baseKey);
                        this.cachedBaseValue = TimeOrderedCachingWindowStore.this.internalContext.cache().get(TimeOrderedCachingWindowStore.this.cacheName, cachedBaseKey);
                        if (this.cachedBaseValue != null) {
                            return true;
                        }
                        this.current.next();
                        continue;
                    }
                    this.getNextSegmentIterator();
                    if (this.current == null) break;
                }
                return false;
            }
            if (this.current.hasNext()) {
                return true;
            }
            while (!this.current.hasNext()) {
                this.getNextSegmentIterator();
                if (this.current != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public Bytes peekNextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.peekNextKey();
        }

        @Override
        public KeyValue<Bytes, LRUCacheEntry> peekNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.useIndex) {
                KeyValue<Bytes, LRUCacheEntry> kv = this.current.peekNext();
                return KeyValue.pair((Bytes)kv.key, this.cachedBaseValue);
            }
            return this.current.peekNext();
        }

        @Override
        public KeyValue<Bytes, LRUCacheEntry> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.useIndex) {
                Object kv = this.current.next();
                return KeyValue.pair((Bytes)((KeyValue)kv).key, this.cachedBaseValue);
            }
            return this.current.next();
        }

        @Override
        public void close() {
            this.current.close();
        }

        private long currentSegmentBeginTime() {
            return this.currentSegmentId * this.segmentInterval;
        }

        private long currentSegmentLastTime() {
            return Math.min(this.timeTo, this.currentSegmentBeginTime() + this.segmentInterval - 1L);
        }

        private void getNextSegmentIterator() {
            if (this.forward) {
                ++this.currentSegmentId;
                this.lastSegmentId = this.cacheFunction.segmentId(Math.min(this.timeTo, TimeOrderedCachingWindowStore.this.maxObservedTimestamp.get()));
                if (this.currentSegmentId > this.lastSegmentId) {
                    this.current = null;
                    return;
                }
                this.setCacheKeyRange(this.currentSegmentBeginTime(), this.currentSegmentLastTime());
                this.current.close();
                this.current = TimeOrderedCachingWindowStore.this.internalContext.cache().range(TimeOrderedCachingWindowStore.this.cacheName, this.cacheKeyFrom, this.cacheKeyTo);
            } else {
                --this.currentSegmentId;
                if (this.currentSegmentId < this.lastSegmentId) {
                    this.current = null;
                    return;
                }
                this.setCacheKeyRange(this.currentSegmentBeginTime(), this.currentSegmentLastTime());
                this.current.close();
                this.current = TimeOrderedCachingWindowStore.this.internalContext.cache().reverseRange(TimeOrderedCachingWindowStore.this.cacheName, this.cacheKeyFrom, this.cacheKeyTo);
            }
        }

        private void setCacheKeyRange(long lowerRangeEndTime, long upperRangeEndTime) {
            SegmentedBytesStore.KeySchema schema;
            if (this.cacheFunction.segmentId(lowerRangeEndTime) != this.cacheFunction.segmentId(upperRangeEndTime)) {
                throw new IllegalStateException("Error iterating over segments: segment interval has changed");
            }
            SegmentedBytesStore.KeySchema keySchema = schema = this.useIndex ? TimeOrderedCachingWindowStore.this.indexKeySchema : TimeOrderedCachingWindowStore.this.baseKeySchema;
            if (this.keyFrom != null && this.keyFrom.equals(this.keyTo)) {
                this.cacheKeyFrom = this.cacheFunction.cacheKey(schema.lowerRangeFixedSize(this.keyFrom, lowerRangeEndTime), this.currentSegmentId);
                this.cacheKeyTo = this.cacheFunction.cacheKey(schema.upperRangeFixedSize(this.keyTo, upperRangeEndTime), this.currentSegmentId);
            } else {
                this.cacheKeyFrom = this.cacheFunction.cacheKey(schema.lowerRange(this.keyFrom, lowerRangeEndTime), this.currentSegmentId);
                this.cacheKeyTo = this.cacheFunction.cacheKey(schema.upperRange(this.keyTo, this.timeTo), this.currentSegmentId);
            }
        }
    }
}

