/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;
import org.apache.kafka.streams.state.internals.SessionKeySchema;

public class PrefixedSessionKeySchemas {
    private static final int PREFIX_SIZE = 1;
    private static final byte TIME_FIRST_PREFIX = 0;
    private static final byte KEY_FIRST_PREFIX = 1;

    private static byte extractPrefix(byte[] binaryBytes) {
        return binaryBytes[0];
    }

    public static class KeyFirstSessionKeySchema
    implements SegmentedBytesStore.KeySchema {
        @Override
        public Bytes upperRange(Bytes key, long to) {
            Bytes noPrefixBytes = new SessionKeySchema().upperRange(key, to);
            return KeyFirstSessionKeySchema.wrapPrefix(noPrefixBytes, true);
        }

        @Override
        public Bytes lowerRange(Bytes key, long from) {
            Bytes noPrefixBytes = new SessionKeySchema().lowerRange(key, from);
            return KeyFirstSessionKeySchema.wrapPrefix(noPrefixBytes, false);
        }

        @Override
        public Bytes upperRangeFixedSize(Bytes key, long to) {
            ByteBuffer buffer = ByteBuffer.allocate(1 + SessionKeySchema.keyByteLength(key));
            buffer.put((byte)1);
            SessionKeySchema.writeBinary(buffer, SessionKeySchema.upperRangeFixedWindow(key, to));
            return Bytes.wrap(buffer.array());
        }

        @Override
        public Bytes lowerRangeFixedSize(Bytes key, long from) {
            ByteBuffer buffer = ByteBuffer.allocate(1 + SessionKeySchema.keyByteLength(key));
            buffer.put((byte)1);
            SessionKeySchema.writeBinary(buffer, SessionKeySchema.lowerRangeFixedWindow(key, from));
            return Bytes.wrap(buffer.array());
        }

        @Override
        public long segmentTimestamp(Bytes key) {
            return KeyFirstSessionKeySchema.extractEndTimestamp(key.get());
        }

        @Override
        public HasNextCondition hasNextCondition(Bytes binaryKeyFrom, Bytes binaryKeyTo, long from, long to, boolean forward) {
            return iterator -> {
                while (iterator.hasNext()) {
                    Bytes bytes = (Bytes)iterator.peekNextKey();
                    byte prefix = PrefixedSessionKeySchemas.extractPrefix(bytes.get());
                    if (prefix != 1) {
                        return false;
                    }
                    Windowed<Bytes> windowedKey = KeyFirstSessionKeySchema.from(bytes);
                    long endTime = windowedKey.window().end();
                    long startTime = windowedKey.window().start();
                    if (!(binaryKeyFrom != null && windowedKey.key().compareTo(binaryKeyFrom) < 0 || binaryKeyTo != null && windowedKey.key().compareTo(binaryKeyTo) > 0 || endTime < from || startTime > to)) {
                        return true;
                    }
                    iterator.next();
                }
                return false;
            };
        }

        @Override
        public <S extends Segment> List<S> segmentsToSearch(Segments<S> segments, long from, long to, boolean forward) {
            return segments.segments(from, Long.MAX_VALUE, forward);
        }

        static Window extractWindow(byte[] binaryKey) {
            ByteBuffer buffer = ByteBuffer.wrap(binaryKey);
            long start = buffer.getLong(binaryKey.length - 8);
            long end = buffer.getLong(binaryKey.length - 16);
            return new SessionWindow(start, end);
        }

        static byte[] extractKeyBytes(byte[] binaryKey) {
            byte[] bytes = new byte[binaryKey.length - 16 - 1];
            System.arraycopy(binaryKey, 1, bytes, 0, bytes.length);
            return bytes;
        }

        public static Windowed<Bytes> from(Bytes bytesKey) {
            byte[] binaryKey = bytesKey.get();
            Window window = KeyFirstSessionKeySchema.extractWindow(binaryKey);
            return new Windowed<Bytes>(Bytes.wrap(KeyFirstSessionKeySchema.extractKeyBytes(binaryKey)), window);
        }

        private static <K> K extractKey(byte[] binaryKey, Deserializer<K> deserializer, String topic) {
            return deserializer.deserialize(topic, KeyFirstSessionKeySchema.extractKeyBytes(binaryKey));
        }

        public static <K> Windowed<K> from(byte[] binaryKey, Deserializer<K> keyDeserializer, String topic) {
            K key = KeyFirstSessionKeySchema.extractKey(binaryKey, keyDeserializer, topic);
            Window window = KeyFirstSessionKeySchema.extractWindow(binaryKey);
            return new Windowed<K>(key, window);
        }

        static long extractStartTimestamp(byte[] binaryKey) {
            return ByteBuffer.wrap(binaryKey).getLong(binaryKey.length - 8);
        }

        static long extractEndTimestamp(byte[] binaryKey) {
            return ByteBuffer.wrap(binaryKey).getLong(binaryKey.length - 16);
        }

        public static Bytes toBinary(Windowed<Bytes> sessionKey) {
            return KeyFirstSessionKeySchema.toBinary(sessionKey.key(), sessionKey.window().start(), sessionKey.window().end());
        }

        public static <K> byte[] toBinary(Windowed<K> sessionKey, Serializer<K> serializer, String topic) {
            byte[] bytes = serializer.serialize(topic, sessionKey.key());
            return KeyFirstSessionKeySchema.toBinary(Bytes.wrap(bytes), sessionKey.window().start(), sessionKey.window().end()).get();
        }

        public static Bytes toBinary(Bytes key, long startTime, long endTime) {
            ByteBuffer buf = ByteBuffer.allocate(1 + SessionKeySchema.keyByteLength(key));
            buf.put((byte)1);
            SessionKeySchema.writeBinary(buf, key, startTime, endTime);
            return Bytes.wrap(buf.array());
        }

        private static Bytes wrapPrefix(Bytes noPrefixKey, boolean upperRange) {
            if (noPrefixKey == null) {
                byte prefix = upperRange ? (byte)2 : 1;
                byte[] ret = ByteBuffer.allocate(1).put(prefix).array();
                return Bytes.wrap(ret);
            }
            byte[] ret = ByteBuffer.allocate(1 + noPrefixKey.get().length).put((byte)1).put(noPrefixKey.get()).array();
            return Bytes.wrap(ret);
        }

        public static byte[] prefixNonPrefixSessionKey(byte[] binaryKey) {
            assert (binaryKey != null);
            return KeyFirstSessionKeySchema.wrapPrefix(Bytes.wrap(binaryKey), false).get();
        }
    }

    public static class TimeFirstSessionKeySchema
    implements SegmentedBytesStore.KeySchema {
        @Override
        public Bytes upperRange(Bytes key, long to) {
            if (key == null) {
                boolean nextPrefix = true;
                return Bytes.wrap(ByteBuffer.allocate(1).put((byte)1).array());
            }
            return Bytes.wrap(ByteBuffer.allocate(17 + key.get().length).put((byte)0).putLong(Long.MAX_VALUE).putLong(to).put(key.get()).array());
        }

        @Override
        public Bytes lowerRange(Bytes key, long from) {
            if (key == null) {
                return Bytes.wrap(ByteBuffer.allocate(9).put((byte)0).putLong(from).array());
            }
            return Bytes.wrap(ByteBuffer.allocate(17 + key.get().length).put((byte)0).putLong(from).putLong(0L).put(key.get()).array());
        }

        @Override
        public Bytes upperRangeFixedSize(Bytes key, long to) {
            return TimeFirstSessionKeySchema.toBinary(key, to, Long.MAX_VALUE);
        }

        @Override
        public Bytes lowerRangeFixedSize(Bytes key, long from) {
            return TimeFirstSessionKeySchema.toBinary(key, 0L, Math.max(0L, from));
        }

        @Override
        public long segmentTimestamp(Bytes key) {
            return TimeFirstSessionKeySchema.extractEndTimestamp(key.get());
        }

        @Override
        public HasNextCondition hasNextCondition(Bytes binaryKeyFrom, Bytes binaryKeyTo, long earliestWindowEndTime, long latestWindowStartTime, boolean forward) {
            return iterator -> {
                while (iterator.hasNext()) {
                    Bytes bytes = (Bytes)iterator.peekNextKey();
                    byte prefix = PrefixedSessionKeySchemas.extractPrefix(bytes.get());
                    if (prefix != 0) {
                        return false;
                    }
                    Windowed<Bytes> windowedKey = TimeFirstSessionKeySchema.from(bytes);
                    long endTime = windowedKey.window().end();
                    long startTime = windowedKey.window().start();
                    if (!forward && endTime < earliestWindowEndTime) {
                        return false;
                    }
                    if (!(binaryKeyFrom != null && windowedKey.key().compareTo(binaryKeyFrom) < 0 || binaryKeyTo != null && windowedKey.key().compareTo(binaryKeyTo) > 0 || endTime < earliestWindowEndTime || startTime > latestWindowStartTime)) {
                        return true;
                    }
                    iterator.next();
                }
                return false;
            };
        }

        @Override
        public <S extends Segment> List<S> segmentsToSearch(Segments<S> segments, long earliestWindowEndTime, long latestWindowStartTime, boolean forward) {
            return segments.segments(earliestWindowEndTime, Long.MAX_VALUE, forward);
        }

        static long extractStartTimestamp(byte[] binaryKey) {
            return ByteBuffer.wrap(binaryKey).getLong(9);
        }

        static long extractEndTimestamp(byte[] binaryKey) {
            return ByteBuffer.wrap(binaryKey).getLong(1);
        }

        private static <K> K extractKey(byte[] binaryKey, Deserializer<K> deserializer, String topic) {
            return deserializer.deserialize(topic, TimeFirstSessionKeySchema.extractKeyBytes(binaryKey));
        }

        static byte[] extractKeyBytes(byte[] binaryKey) {
            byte[] bytes = new byte[binaryKey.length - 16 - 1];
            System.arraycopy(binaryKey, 17, bytes, 0, bytes.length);
            return bytes;
        }

        static Window extractWindow(byte[] binaryKey) {
            ByteBuffer buffer = ByteBuffer.wrap(binaryKey);
            long start = buffer.getLong(9);
            long end = buffer.getLong(1);
            return new SessionWindow(start, end);
        }

        public static Windowed<Bytes> from(Bytes bytesKey) {
            byte[] binaryKey = bytesKey.get();
            Window window = TimeFirstSessionKeySchema.extractWindow(binaryKey);
            return new Windowed<Bytes>(Bytes.wrap(TimeFirstSessionKeySchema.extractKeyBytes(binaryKey)), window);
        }

        public static <K> Windowed<K> from(byte[] binaryKey, Deserializer<K> keyDeserializer, String topic) {
            K key = TimeFirstSessionKeySchema.extractKey(binaryKey, keyDeserializer, topic);
            Window window = TimeFirstSessionKeySchema.extractWindow(binaryKey);
            return new Windowed<K>(key, window);
        }

        public static <K> byte[] toBinary(Windowed<K> sessionKey, Serializer<K> serializer, String topic) {
            byte[] bytes = serializer.serialize(topic, sessionKey.key());
            return TimeFirstSessionKeySchema.toBinary(Bytes.wrap(bytes), sessionKey.window().start(), sessionKey.window().end()).get();
        }

        public static Bytes toBinary(Windowed<Bytes> sessionKey) {
            return TimeFirstSessionKeySchema.toBinary(sessionKey.key(), sessionKey.window().start(), sessionKey.window().end());
        }

        public static void writeBinary(ByteBuffer buf, Bytes key, long startTime, long endTime) {
            buf.putLong(endTime);
            buf.putLong(startTime);
            if (key != null) {
                buf.put(key.get());
            }
        }

        public static Bytes toBinary(Bytes key, long startTime, long endTime) {
            ByteBuffer buf = ByteBuffer.allocate(1 + SessionKeySchema.keyByteLength(key));
            buf.put((byte)0);
            TimeFirstSessionKeySchema.writeBinary(buf, key, startTime, endTime);
            return Bytes.wrap(buf.array());
        }

        public static byte[] extractWindowBytesFromNonPrefixSessionKey(byte[] binaryKey) {
            ByteBuffer buffer = ByteBuffer.allocate(1 + binaryKey.length).put((byte)0);
            buffer.put(binaryKey, binaryKey.length - 16, 16);
            buffer.put(binaryKey, 0, binaryKey.length - 16);
            return buffer.array();
        }
    }
}

