/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.function.Function;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.internals.metrics.OpenIterators;
import org.apache.kafka.streams.state.VersionedRecord;
import org.apache.kafka.streams.state.VersionedRecordIterator;
import org.apache.kafka.streams.state.internals.MeteredIterator;

class MeteredMultiVersionedKeyQueryIterator<V>
implements VersionedRecordIterator<V>,
MeteredIterator {
    private final VersionedRecordIterator<byte[]> iterator;
    private final Function<VersionedRecord<byte[]>, VersionedRecord<V>> deserializeValue;
    private final Sensor sensor;
    private final Time time;
    private final long startNs;
    private final long startTimestampMs;
    private final OpenIterators openIterators;

    public MeteredMultiVersionedKeyQueryIterator(VersionedRecordIterator<byte[]> iterator, Sensor sensor, Time time, Function<VersionedRecord<byte[]>, VersionedRecord<V>> deserializeValue, OpenIterators openIterators) {
        this.iterator = iterator;
        this.deserializeValue = deserializeValue;
        this.openIterators = openIterators;
        this.sensor = sensor;
        this.time = time;
        this.startNs = time.nanoseconds();
        this.startTimestampMs = time.milliseconds();
        openIterators.add(this);
    }

    @Override
    public long startTimestamp() {
        return this.startTimestampMs;
    }

    @Override
    public void close() {
        try {
            this.iterator.close();
        }
        finally {
            this.sensor.record(this.time.nanoseconds() - this.startNs);
            this.openIterators.remove(this);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public VersionedRecord<V> next() {
        return this.deserializeValue.apply((VersionedRecord)this.iterator.next());
    }
}

