/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.MemoryLRUCache;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryNavigableLRUCache
extends MemoryLRUCache {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryNavigableLRUCache.class);

    public MemoryNavigableLRUCache(String name, int maxCacheSize) {
        super(name, maxCacheSize);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        if (Objects.nonNull(from) && Objects.nonNull(to) && from.compareTo(to) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        TreeMap<Bytes, byte[]> treeMap = this.toTreeMap();
        Iterator<Bytes> keys = this.getIterator(treeMap, from, to, true);
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name(), new CacheIterator(keys, treeMap));
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseRange(Bytes from, Bytes to) {
        if (Objects.nonNull(from) && Objects.nonNull(to) && from.compareTo(to) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        TreeMap<Bytes, byte[]> treeMap = this.toTreeMap();
        Iterator<Bytes> keys = this.getIterator(treeMap, from, to, false);
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name(), new CacheIterator(keys, treeMap));
    }

    private Iterator<Bytes> getIterator(TreeMap<Bytes, byte[]> treeMap, Bytes from, Bytes to, boolean forward) {
        if (from == null && to == null) {
            return forward ? treeMap.navigableKeySet().iterator() : treeMap.navigableKeySet().descendingIterator();
        }
        if (from == null) {
            return forward ? treeMap.navigableKeySet().headSet(to, true).iterator() : treeMap.navigableKeySet().headSet(to, true).descendingIterator();
        }
        if (to == null) {
            return forward ? treeMap.navigableKeySet().tailSet(from, true).iterator() : treeMap.navigableKeySet().tailSet(from, true).descendingIterator();
        }
        return forward ? treeMap.navigableKeySet().subSet(from, true, to, true).iterator() : treeMap.navigableKeySet().subSet(from, true, to, true).descendingIterator();
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefixScan(P prefix, PS prefixKeySerializer) {
        Bytes from = Bytes.wrap(prefixKeySerializer.serialize(null, prefix));
        Bytes to = Bytes.increment(from);
        TreeMap<Bytes, byte[]> treeMap = this.toTreeMap();
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name(), new CacheIterator(treeMap.subMap(from, true, to, false).keySet().iterator(), treeMap));
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        return this.range(null, null);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseAll() {
        return this.reverseRange(null, null);
    }

    private synchronized TreeMap<Bytes, byte[]> toTreeMap() {
        return new TreeMap<Bytes, byte[]>(this.map);
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        return StoreQueryUtils.handleBasicQueries(query, positionBound, config, this, this.getPosition(), this.context);
    }

    private static class CacheIterator
    implements KeyValueIterator<Bytes, byte[]> {
        private final Iterator<Bytes> keys;
        private final Map<Bytes, byte[]> entries;

        private CacheIterator(Iterator<Bytes> keys, Map<Bytes, byte[]> entries) {
            this.keys = keys;
            this.entries = entries;
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public KeyValue<Bytes, byte[]> next() {
            Bytes lastKey = this.keys.next();
            return new KeyValue<Bytes, byte[]>(lastKey, this.entries.get(lastKey));
        }

        @Override
        public void close() {
        }

        @Override
        public Bytes peekNextKey() {
            throw new UnsupportedOperationException("peekNextKey not supported");
        }
    }
}

