/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class ListValueStore
extends WrappedStateStore<KeyValueStore<Bytes, byte[]>, Bytes, byte[]>
implements KeyValueStore<Bytes, byte[]> {
    private static final Serde<List<byte[]>> LIST_SERDE = Serdes.ListSerde(ArrayList.class, Serdes.ByteArray());

    ListValueStore(KeyValueStore<Bytes, byte[]> bytesStore) {
        super(bytesStore);
    }

    @Override
    public void put(Bytes key, byte[] addedValue) {
        if (addedValue == null) {
            ((KeyValueStore)this.wrapped()).put(key, null);
        } else {
            byte[] oldValue = (byte[])((KeyValueStore)this.wrapped()).get(key);
            this.putInternal(key, addedValue, oldValue);
        }
    }

    @Override
    public byte[] putIfAbsent(Bytes key, byte[] addedValue) {
        byte[] oldValue = (byte[])((KeyValueStore)this.wrapped()).get(key);
        if (oldValue != null) {
            if (addedValue == null) {
                ((KeyValueStore)this.wrapped()).put(key, null);
            } else {
                this.putInternal(key, addedValue, oldValue);
            }
        }
        return null;
    }

    private void putInternal(Bytes key, byte[] addedValue, byte[] oldValue) {
        if (oldValue == null) {
            ((KeyValueStore)this.wrapped()).put(key, LIST_SERDE.serializer().serialize(null, Collections.singletonList(addedValue)));
        } else {
            List<byte[]> list = LIST_SERDE.deserializer().deserialize(null, oldValue);
            list.add(addedValue);
            ((KeyValueStore)this.wrapped()).put(key, LIST_SERDE.serializer().serialize(null, list));
        }
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        throw new UnsupportedOperationException("putAll not supported");
    }

    @Override
    public byte[] delete(Bytes key) {
        throw new UnsupportedOperationException("delete not supported");
    }

    @Override
    public byte[] get(Bytes key) {
        return (byte[])((KeyValueStore)this.wrapped()).get(key);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        throw new UnsupportedOperationException("range not supported");
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        return new ValueListIterator(((KeyValueStore)this.wrapped()).all());
    }

    @Override
    public long approximateNumEntries() {
        return ((KeyValueStore)this.wrapped()).approximateNumEntries();
    }

    private static class ValueListIterator
    extends AbstractIterator<KeyValue<Bytes, byte[]>>
    implements KeyValueIterator<Bytes, byte[]> {
        private final KeyValueIterator<Bytes, byte[]> bytesIterator;
        private final List<byte[]> currList = new ArrayList<byte[]>();
        private KeyValue<Bytes, byte[]> next;
        private Bytes nextKey;

        ValueListIterator(KeyValueIterator<Bytes, byte[]> bytesIterator) {
            this.bytesIterator = bytesIterator;
        }

        @Override
        public Bytes peekNextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (Bytes)this.next.key;
        }

        @Override
        protected KeyValue<Bytes, byte[]> makeNext() {
            while (this.currList.isEmpty() && this.bytesIterator.hasNext()) {
                KeyValue next = (KeyValue)this.bytesIterator.next();
                this.nextKey = (Bytes)next.key;
                this.currList.addAll((Collection<byte[]>)LIST_SERDE.deserializer().deserialize(null, (byte[])next.value));
            }
            if (this.currList.isEmpty()) {
                return (KeyValue)this.allDone();
            }
            this.next = KeyValue.pair(this.nextKey, this.currList.remove(0));
            return this.next;
        }

        @Override
        public void close() {
            this.bytesIterator.close();
            this.currList.clear();
        }
    }
}

