/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.state.internals.LeftOrRightValue;

public class LeftOrRightValueSerializer<V1, V2>
implements WrappingNullableSerializer<LeftOrRightValue<V1, V2>, Void, Object> {
    private Serializer<V1> leftSerializer;
    private Serializer<V2> rightSerializer;

    public LeftOrRightValueSerializer(Serializer<V1> leftSerializer, Serializer<V2> rightSerializer) {
        this.leftSerializer = leftSerializer;
        this.rightSerializer = rightSerializer;
    }

    @Override
    public void setIfUnset(SerdeGetter getter) {
        if (this.leftSerializer == null) {
            this.leftSerializer = getter.valueSerde().serializer();
        }
        if (this.rightSerializer == null) {
            this.rightSerializer = getter.valueSerde().serializer();
        }
        WrappingNullableUtils.initNullableSerializer(this.leftSerializer, getter);
        WrappingNullableUtils.initNullableSerializer(this.rightSerializer, getter);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.leftSerializer.configure(configs, isKey);
        this.rightSerializer.configure(configs, isKey);
    }

    @Override
    public byte[] serialize(String topic, LeftOrRightValue<V1, V2> data) {
        byte[] rawValue;
        if (data == null) {
            return null;
        }
        byte[] byArray = rawValue = data.leftValue() != null ? this.leftSerializer.serialize(topic, data.leftValue()) : this.rightSerializer.serialize(topic, data.rightValue());
        if (rawValue == null) {
            return null;
        }
        return ByteBuffer.allocate(1 + rawValue.length).put((byte)(data.leftValue() != null ? 1 : 0)).put(rawValue).array();
    }

    @Override
    public void close() {
        this.leftSerializer.close();
        this.rightSerializer.close();
    }
}

