/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;

public class ContextualRecord {
    private final byte[] value;
    private final ProcessorRecordContext recordContext;

    public ContextualRecord(byte[] value, ProcessorRecordContext recordContext) {
        this.value = value;
        this.recordContext = Objects.requireNonNull(recordContext);
    }

    public ProcessorRecordContext recordContext() {
        return this.recordContext;
    }

    public byte[] value() {
        return this.value;
    }

    long residentMemorySizeEstimate() {
        return (long)(this.value == null ? 0 : this.value.length) + this.recordContext.residentMemorySizeEstimate();
    }

    static ContextualRecord deserialize(ByteBuffer buffer) {
        ProcessorRecordContext context = ProcessorRecordContext.deserialize(buffer);
        byte[] value = Utils.getNullableSizePrefixedArray(buffer);
        return new ContextualRecord(value, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualRecord that = (ContextualRecord)o;
        return Arrays.equals(this.value, that.value) && Objects.equals(this.recordContext, that.recordContext);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("ContextualRecord.ProcessorRecordContext is unsafe for use in Hash collections due to the mutable Headers field");
    }

    public String toString() {
        return "ContextualRecord{recordContext=" + String.valueOf(this.recordContext) + ", value=" + Arrays.toString(this.value) + "}";
    }
}

